/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeprecateActivityTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeprecateActivityTypeRequest.Builder, DeprecateActivityTypeRequest> {
    private final String domain;

    private final ActivityType activityType;

    private DeprecateActivityTypeRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.activityType = builder.activityType;
    }

    /**
     * <p>
     * The name of the domain in which the activity type is registered.
     * </p>
     * 
     * @return The name of the domain in which the activity type is registered.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The activity type to deprecate.
     * </p>
     * 
     * @return The activity type to deprecate.
     */
    public ActivityType activityType() {
        return activityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((activityType() == null) ? 0 : activityType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecateActivityTypeRequest)) {
            return false;
        }
        DeprecateActivityTypeRequest other = (DeprecateActivityTypeRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.activityType() == null ^ this.activityType() == null) {
            return false;
        }
        if (other.activityType() != null && !other.activityType().equals(this.activityType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (activityType() != null) {
            sb.append("ActivityType: ").append(activityType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeprecateActivityTypeRequest> {
        /**
         * <p>
         * The name of the domain in which the activity type is registered.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which the activity type is registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The activity type to deprecate.
         * </p>
         * 
         * @param activityType
         *        The activity type to deprecate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private ActivityType activityType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecateActivityTypeRequest model) {
            setDomain(model.domain);
            setActivityType(model.activityType);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ActivityType getActivityType() {
            return activityType;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType activityType) {
            this.activityType = activityType;
        }

        @Override
        public DeprecateActivityTypeRequest build() {
            return new DeprecateActivityTypeRequest(this);
        }
    }
}
