/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.DecisionTaskTimedOutEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>DecisionTaskTimedOut</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DecisionTaskTimedOutEventAttributes implements StructuredPojo,
        ToCopyableBuilder<DecisionTaskTimedOutEventAttributes.Builder, DecisionTaskTimedOutEventAttributes> {
    private final String timeoutType;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private DecisionTaskTimedOutEventAttributes(BuilderImpl builder) {
        this.timeoutType = builder.timeoutType;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The type of timeout that expired before the decision task could be completed.
     * </p>
     * 
     * @return The type of timeout that expired before the decision task could be completed.
     * @see DecisionTaskTimeoutType
     */
    public String timeoutType() {
        return timeoutType;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timeoutType() == null) ? 0 : timeoutType().hashCode());
        hashCode = 31 * hashCode + ((scheduledEventId() == null) ? 0 : scheduledEventId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTaskTimedOutEventAttributes)) {
            return false;
        }
        DecisionTaskTimedOutEventAttributes other = (DecisionTaskTimedOutEventAttributes) obj;
        if (other.timeoutType() == null ^ this.timeoutType() == null) {
            return false;
        }
        if (other.timeoutType() != null && !other.timeoutType().equals(this.timeoutType())) {
            return false;
        }
        if (other.scheduledEventId() == null ^ this.scheduledEventId() == null) {
            return false;
        }
        if (other.scheduledEventId() != null && !other.scheduledEventId().equals(this.scheduledEventId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timeoutType() != null) {
            sb.append("TimeoutType: ").append(timeoutType()).append(",");
        }
        if (scheduledEventId() != null) {
            sb.append("ScheduledEventId: ").append(scheduledEventId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DecisionTaskTimedOutEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DecisionTaskTimedOutEventAttributes> {
        /**
         * <p>
         * The type of timeout that expired before the decision task could be completed.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that expired before the decision task could be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecisionTaskTimeoutType
         */
        Builder timeoutType(String timeoutType);

        /**
         * <p>
         * The type of timeout that expired before the decision task could be completed.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that expired before the decision task could be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecisionTaskTimeoutType
         */
        Builder timeoutType(DecisionTaskTimeoutType timeoutType);

        /**
         * <p>
         * The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>DecisionTaskScheduled</code> event that was recorded when this decision task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>DecisionTaskStarted</code> event recorded when this decision task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String timeoutType;

        private Long scheduledEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(DecisionTaskTimedOutEventAttributes model) {
            setTimeoutType(model.timeoutType);
            setScheduledEventId(model.scheduledEventId);
            setStartedEventId(model.startedEventId);
        }

        public final String getTimeoutType() {
            return timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(DecisionTaskTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        public final void setTimeoutType(DecisionTaskTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public DecisionTaskTimedOutEventAttributes build() {
            return new DecisionTaskTimedOutEventAttributes(this);
        }
    }
}
