/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.DecisionTaskScheduledEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the <code>DecisionTaskScheduled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DecisionTaskScheduledEventAttributes implements StructuredPojo,
        ToCopyableBuilder<DecisionTaskScheduledEventAttributes.Builder, DecisionTaskScheduledEventAttributes> {
    private final TaskList taskList;

    private final String taskPriority;

    private final String startToCloseTimeout;

    private DecisionTaskScheduledEventAttributes(BuilderImpl builder) {
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.startToCloseTimeout = builder.startToCloseTimeout;
    }

    /**
     * <p>
     * The name of the task list in which the decision task was scheduled.
     * </p>
     * 
     * @return The name of the task list in which the decision task was scheduled.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * <i>Optional.</i> A task priority that, if set, specifies the priority for this decision task. Valid values are
     * integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code>
     * (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return Optional.</i> A task priority that, if set, specifies the priority for this decision task. Valid values
     *         are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The maximum duration for this decision task. The task is considered timed out if it does not completed within
     * this duration.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration for this decision task. The task is considered timed out if it does not completed
     *         within this duration.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((taskPriority() == null) ? 0 : taskPriority().hashCode());
        hashCode = 31 * hashCode + ((startToCloseTimeout() == null) ? 0 : startToCloseTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTaskScheduledEventAttributes)) {
            return false;
        }
        DecisionTaskScheduledEventAttributes other = (DecisionTaskScheduledEventAttributes) obj;
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.startToCloseTimeout() == null ^ this.startToCloseTimeout() == null) {
            return false;
        }
        if (other.startToCloseTimeout() != null && !other.startToCloseTimeout().equals(this.startToCloseTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (taskPriority() != null) {
            sb.append("TaskPriority: ").append(taskPriority()).append(",");
        }
        if (startToCloseTimeout() != null) {
            sb.append("StartToCloseTimeout: ").append(startToCloseTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DecisionTaskScheduledEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DecisionTaskScheduledEventAttributes> {
        /**
         * <p>
         * The name of the task list in which the decision task was scheduled.
         * </p>
         * 
         * @param taskList
         *        The name of the task list in which the decision task was scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * <i>Optional.</i> A task priority that, if set, specifies the priority for this decision task. Valid values
         * are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        Optional.</i> A task priority that, if set, specifies the priority for this decision task. Valid
         *        values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The maximum duration for this decision task. The task is considered timed out if it does not completed within
         * this duration.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param startToCloseTimeout
         *        The maximum duration for this decision task. The task is considered timed out if it does not completed
         *        within this duration.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private TaskList taskList;

        private String taskPriority;

        private String startToCloseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(DecisionTaskScheduledEventAttributes model) {
            setTaskList(model.taskList);
            setTaskPriority(model.taskPriority);
            setStartToCloseTimeout(model.startToCloseTimeout);
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        @Override
        public DecisionTaskScheduledEventAttributes build() {
            return new DecisionTaskScheduledEventAttributes(this);
        }
    }
}
