/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CountOpenWorkflowExecutionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CountOpenWorkflowExecutionsRequest.Builder, CountOpenWorkflowExecutionsRequest> {
    private final String domain;

    private final ExecutionTimeFilter startTimeFilter;

    private final WorkflowTypeFilter typeFilter;

    private final TagFilter tagFilter;

    private final WorkflowExecutionFilter executionFilter;

    private CountOpenWorkflowExecutionsRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.executionFilter = builder.executionFilter;
    }

    /**
     * <p>
     * The name of the domain containing the workflow executions to count.
     * </p>
     * 
     * @return The name of the domain containing the workflow executions to count.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * Specifies the start time criteria that workflow executions must meet in order to be counted.
     * </p>
     * 
     * @return Specifies the start time criteria that workflow executions must meet in order to be counted.
     */
    public ExecutionTimeFilter startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * Specifies the type of the workflow executions to be counted.
     * </p>
     * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     * You can specify at most one of these in a request.</note>
     * 
     * @return Specifies the type of the workflow executions to be counted.</p> <note><code>executionFilter</code>,
     *         <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one of
     *         these in a request.
     */
    public WorkflowTypeFilter typeFilter() {
        return typeFilter;
    }

    /**
     * <p>
     * If specified, only executions that have a tag that matches the filter are counted.
     * </p>
     * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     * You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only executions that have a tag that matches the filter are counted.</p> <note>
     *         <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     *         You can specify at most one of these in a request.
     */
    public TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
     * </p>
     * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive.
     * You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
     *         counted.</p> <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are
     *         mutually exclusive. You can specify at most one of these in a request.
     */
    public WorkflowExecutionFilter executionFilter() {
        return executionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((startTimeFilter() == null) ? 0 : startTimeFilter().hashCode());
        hashCode = 31 * hashCode + ((typeFilter() == null) ? 0 : typeFilter().hashCode());
        hashCode = 31 * hashCode + ((tagFilter() == null) ? 0 : tagFilter().hashCode());
        hashCode = 31 * hashCode + ((executionFilter() == null) ? 0 : executionFilter().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountOpenWorkflowExecutionsRequest)) {
            return false;
        }
        CountOpenWorkflowExecutionsRequest other = (CountOpenWorkflowExecutionsRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.startTimeFilter() == null ^ this.startTimeFilter() == null) {
            return false;
        }
        if (other.startTimeFilter() != null && !other.startTimeFilter().equals(this.startTimeFilter())) {
            return false;
        }
        if (other.typeFilter() == null ^ this.typeFilter() == null) {
            return false;
        }
        if (other.typeFilter() != null && !other.typeFilter().equals(this.typeFilter())) {
            return false;
        }
        if (other.tagFilter() == null ^ this.tagFilter() == null) {
            return false;
        }
        if (other.tagFilter() != null && !other.tagFilter().equals(this.tagFilter())) {
            return false;
        }
        if (other.executionFilter() == null ^ this.executionFilter() == null) {
            return false;
        }
        if (other.executionFilter() != null && !other.executionFilter().equals(this.executionFilter())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (startTimeFilter() != null) {
            sb.append("StartTimeFilter: ").append(startTimeFilter()).append(",");
        }
        if (typeFilter() != null) {
            sb.append("TypeFilter: ").append(typeFilter()).append(",");
        }
        if (tagFilter() != null) {
            sb.append("TagFilter: ").append(tagFilter()).append(",");
        }
        if (executionFilter() != null) {
            sb.append("ExecutionFilter: ").append(executionFilter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CountOpenWorkflowExecutionsRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow executions to count.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow executions to count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specifies the start time criteria that workflow executions must meet in order to be counted.
         * </p>
         * 
         * @param startTimeFilter
         *        Specifies the start time criteria that workflow executions must meet in order to be counted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(ExecutionTimeFilter startTimeFilter);

        /**
         * <p>
         * Specifies the type of the workflow executions to be counted.
         * </p>
         * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         * exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param typeFilter
         *        Specifies the type of the workflow executions to be counted.</p> <note><code>executionFilter</code>,
         *        <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one
         *        of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeFilter(WorkflowTypeFilter typeFilter);

        /**
         * <p>
         * If specified, only executions that have a tag that matches the filter are counted.
         * </p>
         * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         * exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param tagFilter
         *        If specified, only executions that have a tag that matches the filter are counted.</p> <note>
         *        <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         *        exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
         * </p>
         * <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code> are mutually
         * exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param executionFilter
         *        If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
         *        counted.</p> <note><code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
         *        are mutually exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFilter(WorkflowExecutionFilter executionFilter);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private ExecutionTimeFilter startTimeFilter;

        private WorkflowTypeFilter typeFilter;

        private TagFilter tagFilter;

        private WorkflowExecutionFilter executionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CountOpenWorkflowExecutionsRequest model) {
            setDomain(model.domain);
            setStartTimeFilter(model.startTimeFilter);
            setTypeFilter(model.typeFilter);
            setTagFilter(model.tagFilter);
            setExecutionFilter(model.executionFilter);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ExecutionTimeFilter getStartTimeFilter() {
            return startTimeFilter;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
        }

        public final WorkflowTypeFilter getTypeFilter() {
            return typeFilter;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final void setTypeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
        }

        public final TagFilter getTagFilter() {
            return tagFilter;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final void setTagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
        }

        public final WorkflowExecutionFilter getExecutionFilter() {
            return executionFilter;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
        }

        @Override
        public CountOpenWorkflowExecutionsRequest build() {
            return new CountOpenWorkflowExecutionsRequest(this);
        }
    }
}
