/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CountClosedWorkflowExecutionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CountClosedWorkflowExecutionsRequest.Builder, CountClosedWorkflowExecutionsRequest> {
    private final String domain;

    private final ExecutionTimeFilter startTimeFilter;

    private final ExecutionTimeFilter closeTimeFilter;

    private final WorkflowExecutionFilter executionFilter;

    private final WorkflowTypeFilter typeFilter;

    private final TagFilter tagFilter;

    private final CloseStatusFilter closeStatusFilter;

    private CountClosedWorkflowExecutionsRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.closeTimeFilter = builder.closeTimeFilter;
        this.executionFilter = builder.executionFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.closeStatusFilter = builder.closeStatusFilter;
    }

    /**
     * <p>
     * The name of the domain containing the workflow executions to count.
     * </p>
     * 
     * @return The name of the domain containing the workflow executions to count.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * If specified, only workflow executions that meet the start time criteria of the filter are counted.
     * </p>
     * <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one
     * of these in a request but not both.</note>
     * 
     * @return If specified, only workflow executions that meet the start time criteria of the filter are counted.</p>
     *         <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must
     *         specify one of these in a request but not both.
     */
    public ExecutionTimeFilter startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions that meet the close time criteria of the filter are counted.
     * </p>
     * <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one
     * of these in a request but not both.</note>
     * 
     * @return If specified, only workflow executions that meet the close time criteria of the filter are counted.</p>
     *         <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must
     *         specify one of these in a request but not both.
     */
    public ExecutionTimeFilter closeTimeFilter() {
        return closeTimeFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
     * </p>
     * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
     *         counted.</p> <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code>
     *         and <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     */
    public WorkflowExecutionFilter executionFilter() {
        return executionFilter;
    }

    /**
     * <p>
     * If specified, indicates the type of the workflow executions to be counted.
     * </p>
     * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
     * 
     * @return If specified, indicates the type of the workflow executions to be counted.</p> <note>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     */
    public WorkflowTypeFilter typeFilter() {
        return typeFilter;
    }

    /**
     * <p>
     * If specified, only executions that have a tag that matches the filter are counted.
     * </p>
     * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only executions that have a tag that matches the filter are counted.</p> <note>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     */
    public TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions that match this close status are counted. This filter has an affect only
     * if <code>executionStatus</code> is specified as <code>CLOSED</code>.
     * </p>
     * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
     * 
     * @return If specified, only workflow executions that match this close status are counted. This filter has an
     *         affect only if <code>executionStatus</code> is specified as <code>CLOSED</code>.</p> <note>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     */
    public CloseStatusFilter closeStatusFilter() {
        return closeStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((startTimeFilter() == null) ? 0 : startTimeFilter().hashCode());
        hashCode = 31 * hashCode + ((closeTimeFilter() == null) ? 0 : closeTimeFilter().hashCode());
        hashCode = 31 * hashCode + ((executionFilter() == null) ? 0 : executionFilter().hashCode());
        hashCode = 31 * hashCode + ((typeFilter() == null) ? 0 : typeFilter().hashCode());
        hashCode = 31 * hashCode + ((tagFilter() == null) ? 0 : tagFilter().hashCode());
        hashCode = 31 * hashCode + ((closeStatusFilter() == null) ? 0 : closeStatusFilter().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountClosedWorkflowExecutionsRequest)) {
            return false;
        }
        CountClosedWorkflowExecutionsRequest other = (CountClosedWorkflowExecutionsRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.startTimeFilter() == null ^ this.startTimeFilter() == null) {
            return false;
        }
        if (other.startTimeFilter() != null && !other.startTimeFilter().equals(this.startTimeFilter())) {
            return false;
        }
        if (other.closeTimeFilter() == null ^ this.closeTimeFilter() == null) {
            return false;
        }
        if (other.closeTimeFilter() != null && !other.closeTimeFilter().equals(this.closeTimeFilter())) {
            return false;
        }
        if (other.executionFilter() == null ^ this.executionFilter() == null) {
            return false;
        }
        if (other.executionFilter() != null && !other.executionFilter().equals(this.executionFilter())) {
            return false;
        }
        if (other.typeFilter() == null ^ this.typeFilter() == null) {
            return false;
        }
        if (other.typeFilter() != null && !other.typeFilter().equals(this.typeFilter())) {
            return false;
        }
        if (other.tagFilter() == null ^ this.tagFilter() == null) {
            return false;
        }
        if (other.tagFilter() != null && !other.tagFilter().equals(this.tagFilter())) {
            return false;
        }
        if (other.closeStatusFilter() == null ^ this.closeStatusFilter() == null) {
            return false;
        }
        if (other.closeStatusFilter() != null && !other.closeStatusFilter().equals(this.closeStatusFilter())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (startTimeFilter() != null) {
            sb.append("StartTimeFilter: ").append(startTimeFilter()).append(",");
        }
        if (closeTimeFilter() != null) {
            sb.append("CloseTimeFilter: ").append(closeTimeFilter()).append(",");
        }
        if (executionFilter() != null) {
            sb.append("ExecutionFilter: ").append(executionFilter()).append(",");
        }
        if (typeFilter() != null) {
            sb.append("TypeFilter: ").append(typeFilter()).append(",");
        }
        if (tagFilter() != null) {
            sb.append("TagFilter: ").append(tagFilter()).append(",");
        }
        if (closeStatusFilter() != null) {
            sb.append("CloseStatusFilter: ").append(closeStatusFilter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CountClosedWorkflowExecutionsRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow executions to count.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow executions to count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * If specified, only workflow executions that meet the start time criteria of the filter are counted.
         * </p>
         * <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
         * one of these in a request but not both.</note>
         * 
         * @param startTimeFilter
         *        If specified, only workflow executions that meet the start time criteria of the filter are
         *        counted.</p> <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually
         *        exclusive. You must specify one of these in a request but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(ExecutionTimeFilter startTimeFilter);

        /**
         * <p>
         * If specified, only workflow executions that meet the close time criteria of the filter are counted.
         * </p>
         * <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
         * one of these in a request but not both.</note>
         * 
         * @param closeTimeFilter
         *        If specified, only workflow executions that meet the close time criteria of the filter are
         *        counted.</p> <note><code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually
         *        exclusive. You must specify one of these in a request but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter);

        /**
         * <p>
         * If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are counted.
         * </p>
         * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param executionFilter
         *        If specified, only workflow executions matching the <code>WorkflowId</code> in the filter are
         *        counted.</p> <note><code>closeStatusFilter</code>, <code>executionFilter</code>,
         *        <code>typeFilter</code> and <code>tagFilter</code> are mutually exclusive. You can specify at most one
         *        of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFilter(WorkflowExecutionFilter executionFilter);

        /**
         * <p>
         * If specified, indicates the type of the workflow executions to be counted.
         * </p>
         * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param typeFilter
         *        If specified, indicates the type of the workflow executions to be counted.</p> <note>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeFilter(WorkflowTypeFilter typeFilter);

        /**
         * <p>
         * If specified, only executions that have a tag that matches the filter are counted.
         * </p>
         * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param tagFilter
         *        If specified, only executions that have a tag that matches the filter are counted.</p> <note>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * If specified, only workflow executions that match this close status are counted. This filter has an affect
         * only if <code>executionStatus</code> is specified as <code>CLOSED</code>.
         * </p>
         * <note><code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.</note>
         * 
         * @param closeStatusFilter
         *        If specified, only workflow executions that match this close status are counted. This filter has an
         *        affect only if <code>executionStatus</code> is specified as <code>CLOSED</code>.</p> <note>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeStatusFilter(CloseStatusFilter closeStatusFilter);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private ExecutionTimeFilter startTimeFilter;

        private ExecutionTimeFilter closeTimeFilter;

        private WorkflowExecutionFilter executionFilter;

        private WorkflowTypeFilter typeFilter;

        private TagFilter tagFilter;

        private CloseStatusFilter closeStatusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(CountClosedWorkflowExecutionsRequest model) {
            setDomain(model.domain);
            setStartTimeFilter(model.startTimeFilter);
            setCloseTimeFilter(model.closeTimeFilter);
            setExecutionFilter(model.executionFilter);
            setTypeFilter(model.typeFilter);
            setTagFilter(model.tagFilter);
            setCloseStatusFilter(model.closeStatusFilter);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ExecutionTimeFilter getStartTimeFilter() {
            return startTimeFilter;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
        }

        public final ExecutionTimeFilter getCloseTimeFilter() {
            return closeTimeFilter;
        }

        @Override
        public final Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter;
            return this;
        }

        public final void setCloseTimeFilter(ExecutionTimeFilter closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter;
        }

        public final WorkflowExecutionFilter getExecutionFilter() {
            return executionFilter;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
        }

        public final WorkflowTypeFilter getTypeFilter() {
            return typeFilter;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final void setTypeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
        }

        public final TagFilter getTagFilter() {
            return tagFilter;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final void setTagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
        }

        public final CloseStatusFilter getCloseStatusFilter() {
            return closeStatusFilter;
        }

        @Override
        public final Builder closeStatusFilter(CloseStatusFilter closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter;
            return this;
        }

        public final void setCloseStatusFilter(CloseStatusFilter closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter;
        }

        @Override
        public CountClosedWorkflowExecutionsRequest build() {
            return new CountClosedWorkflowExecutionsRequest(this);
        }
    }
}
