/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.CloseStatusFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to filter the closed workflow executions in visibility APIs by their close status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloseStatusFilter implements StructuredPojo, ToCopyableBuilder<CloseStatusFilter.Builder, CloseStatusFilter> {
    private final String status;

    private CloseStatusFilter(BuilderImpl builder) {
        this.status = builder.status;
    }

    /**
     * <p>
     * <b>Required.</b> The close status that must match the close status of an execution for it to meet the criteria of
     * this filter.
     * </p>
     * 
     * @return Required.
     * @see CloseStatus
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloseStatusFilter)) {
            return false;
        }
        CloseStatusFilter other = (CloseStatusFilter) obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloseStatusFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloseStatusFilter> {
        /**
         * <p>
         * <b>Required.</b> The close status that must match the close status of an execution for it to meet the
         * criteria of this filter.
         * </p>
         * 
         * @param status
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * <b>Required.</b> The close status that must match the close status of an execution for it to meet the
         * criteria of this filter.
         * </p>
         * 
         * @param status
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloseStatus
         */
        Builder status(CloseStatus status);
    }

    private static final class BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CloseStatusFilter model) {
            setStatus(model.status);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CloseStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(CloseStatus status) {
            this.status(status.toString());
        }

        @Override
        public CloseStatusFilter build() {
            return new CloseStatusFilter(this);
        }
    }
}
