/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ChildWorkflowExecutionTerminatedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ChildWorkflowExecutionTerminated</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChildWorkflowExecutionTerminatedEventAttributes
        implements
        StructuredPojo,
        ToCopyableBuilder<ChildWorkflowExecutionTerminatedEventAttributes.Builder, ChildWorkflowExecutionTerminatedEventAttributes> {
    private final WorkflowExecution workflowExecution;

    private final WorkflowType workflowType;

    private final Long initiatedEventId;

    private final Long startedEventId;

    private ChildWorkflowExecutionTerminatedEventAttributes(BuilderImpl builder) {
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.initiatedEventId = builder.initiatedEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The child workflow execution that was terminated.
     * </p>
     * 
     * @return The child workflow execution that was terminated.
     */
    public WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The type of the child workflow execution.
     * </p>
     * 
     * @return The type of the child workflow execution.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     * <code>StartChildWorkflowExecution</code> decision to start this child workflow execution. This information can be
     * useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>StartChildWorkflowExecution</code> decision to start this child workflow execution. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long initiatedEventId() {
        return initiatedEventId;
    }

    /**
     * <p>
     * The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution was
     * started. This information can be useful for diagnosing problems by tracing back the chain of events leading up to
     * this event.
     * </p>
     * 
     * @return The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow
     *         execution was started. This information can be useful for diagnosing problems by tracing back the chain
     *         of events leading up to this event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowExecution() == null) ? 0 : workflowExecution().hashCode());
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        hashCode = 31 * hashCode + ((initiatedEventId() == null) ? 0 : initiatedEventId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChildWorkflowExecutionTerminatedEventAttributes)) {
            return false;
        }
        ChildWorkflowExecutionTerminatedEventAttributes other = (ChildWorkflowExecutionTerminatedEventAttributes) obj;
        if (other.workflowExecution() == null ^ this.workflowExecution() == null) {
            return false;
        }
        if (other.workflowExecution() != null && !other.workflowExecution().equals(this.workflowExecution())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.initiatedEventId() == null ^ this.initiatedEventId() == null) {
            return false;
        }
        if (other.initiatedEventId() != null && !other.initiatedEventId().equals(this.initiatedEventId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowExecution() != null) {
            sb.append("WorkflowExecution: ").append(workflowExecution()).append(",");
        }
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        if (initiatedEventId() != null) {
            sb.append("InitiatedEventId: ").append(initiatedEventId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChildWorkflowExecutionTerminatedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ChildWorkflowExecutionTerminatedEventAttributes> {
        /**
         * <p>
         * The child workflow execution that was terminated.
         * </p>
         * 
         * @param workflowExecution
         *        The child workflow execution that was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The type of the child workflow execution.
         * </p>
         * 
         * @param workflowType
         *        The type of the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         * <code>StartChildWorkflowExecution</code> decision to start this child workflow execution. This information
         * can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param initiatedEventId
         *        The ID of the <code>StartChildWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>StartChildWorkflowExecution</code> decision to start this child workflow execution. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);

        /**
         * <p>
         * The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow execution
         * was started. This information can be useful for diagnosing problems by tracing back the chain of events
         * leading up to this event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ChildWorkflowExecutionStarted</code> event recorded when this child workflow
         *        execution was started. This information can be useful for diagnosing problems by tracing back the
         *        chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowExecution workflowExecution;

        private WorkflowType workflowType;

        private Long initiatedEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChildWorkflowExecutionTerminatedEventAttributes model) {
            setWorkflowExecution(model.workflowExecution);
            setWorkflowType(model.workflowType);
            setInitiatedEventId(model.initiatedEventId);
            setStartedEventId(model.startedEventId);
        }

        public final WorkflowExecution getWorkflowExecution() {
            return workflowExecution;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public ChildWorkflowExecutionTerminatedEventAttributes build() {
            return new ChildWorkflowExecutionTerminatedEventAttributes(this);
        }
    }
}
