/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.transform.ActivityTypeInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an activity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActivityTypeInfo implements StructuredPojo, ToCopyableBuilder<ActivityTypeInfo.Builder, ActivityTypeInfo> {
    private final ActivityType activityType;

    private final String status;

    private final String description;

    private final Date creationDate;

    private final Date deprecationDate;

    private ActivityTypeInfo(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.deprecationDate = builder.deprecationDate;
    }

    /**
     * <p>
     * The <a>ActivityType</a> type structure representing the activity type.
     * </p>
     * 
     * @return The <a>ActivityType</a> type structure representing the activity type.
     */
    public ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The current status of the activity type.
     * </p>
     * 
     * @return The current status of the activity type.
     * @see RegistrationStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The description of the activity type provided in <a>RegisterActivityType</a>.
     * </p>
     * 
     * @return The description of the activity type provided in <a>RegisterActivityType</a>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date and time this activity type was created through <a>RegisterActivityType</a>.
     * </p>
     * 
     * @return The date and time this activity type was created through <a>RegisterActivityType</a>.
     */
    public Date creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
     * </p>
     * 
     * @return If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
     */
    public Date deprecationDate() {
        return deprecationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activityType() == null) ? 0 : activityType().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((deprecationDate() == null) ? 0 : deprecationDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTypeInfo)) {
            return false;
        }
        ActivityTypeInfo other = (ActivityTypeInfo) obj;
        if (other.activityType() == null ^ this.activityType() == null) {
            return false;
        }
        if (other.activityType() != null && !other.activityType().equals(this.activityType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.deprecationDate() == null ^ this.deprecationDate() == null) {
            return false;
        }
        if (other.deprecationDate() != null && !other.deprecationDate().equals(this.deprecationDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activityType() != null) {
            sb.append("ActivityType: ").append(activityType()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (deprecationDate() != null) {
            sb.append("DeprecationDate: ").append(deprecationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityTypeInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ActivityTypeInfo> {
        /**
         * <p>
         * The <a>ActivityType</a> type structure representing the activity type.
         * </p>
         * 
         * @param activityType
         *        The <a>ActivityType</a> type structure representing the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The current status of the activity type.
         * </p>
         * 
         * @param status
         *        The current status of the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the activity type.
         * </p>
         * 
         * @param status
         *        The current status of the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(RegistrationStatus status);

        /**
         * <p>
         * The description of the activity type provided in <a>RegisterActivityType</a>.
         * </p>
         * 
         * @param description
         *        The description of the activity type provided in <a>RegisterActivityType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time this activity type was created through <a>RegisterActivityType</a>.
         * </p>
         * 
         * @param creationDate
         *        The date and time this activity type was created through <a>RegisterActivityType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Date creationDate);

        /**
         * <p>
         * If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
         * </p>
         * 
         * @param deprecationDate
         *        If DEPRECATED, the date and time <a>DeprecateActivityType</a> was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDate(Date deprecationDate);
    }

    private static final class BuilderImpl implements Builder {
        private ActivityType activityType;

        private String status;

        private String description;

        private Date creationDate;

        private Date deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTypeInfo model) {
            setActivityType(model.activityType);
            setStatus(model.status);
            setDescription(model.description);
            setCreationDate(model.creationDate);
            setDeprecationDate(model.deprecationDate);
        }

        public final ActivityType getActivityType() {
            return activityType;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType activityType) {
            this.activityType = activityType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(RegistrationStatus status) {
            this.status(status.toString());
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Date getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
        }

        public final Date getDeprecationDate() {
            return deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy(deprecationDate);
            return this;
        }

        public final void setDeprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy(deprecationDate);
        }

        @Override
        public ActivityTypeInfo build() {
            return new ActivityTypeInfo(this);
        }
    }
}
