/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ActivityTaskTimedOutEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ActivityTaskTimedOut</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActivityTaskTimedOutEventAttributes implements StructuredPojo,
        ToCopyableBuilder<ActivityTaskTimedOutEventAttributes.Builder, ActivityTaskTimedOutEventAttributes> {
    private final String timeoutType;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private final String details;

    private ActivityTaskTimedOutEventAttributes(BuilderImpl builder) {
        this.timeoutType = builder.timeoutType;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
        this.details = builder.details;
    }

    /**
     * <p>
     * The type of the timeout that caused this event.
     * </p>
     * 
     * @return The type of the timeout that caused this event.
     * @see ActivityTaskTimeoutType
     */
    public String timeoutType() {
        return timeoutType;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * Contains the content of the <code>details</code> parameter for the last call made by the activity to
     * <code>RecordActivityTaskHeartbeat</code>.
     * </p>
     * 
     * @return Contains the content of the <code>details</code> parameter for the last call made by the activity to
     *         <code>RecordActivityTaskHeartbeat</code>.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timeoutType() == null) ? 0 : timeoutType().hashCode());
        hashCode = 31 * hashCode + ((scheduledEventId() == null) ? 0 : scheduledEventId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskTimedOutEventAttributes)) {
            return false;
        }
        ActivityTaskTimedOutEventAttributes other = (ActivityTaskTimedOutEventAttributes) obj;
        if (other.timeoutType() == null ^ this.timeoutType() == null) {
            return false;
        }
        if (other.timeoutType() != null && !other.timeoutType().equals(this.timeoutType())) {
            return false;
        }
        if (other.scheduledEventId() == null ^ this.scheduledEventId() == null) {
            return false;
        }
        if (other.scheduledEventId() != null && !other.scheduledEventId().equals(this.scheduledEventId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timeoutType() != null) {
            sb.append("TimeoutType: ").append(timeoutType()).append(",");
        }
        if (scheduledEventId() != null) {
            sb.append("ScheduledEventId: ").append(scheduledEventId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityTaskTimedOutEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ActivityTaskTimedOutEventAttributes> {
        /**
         * <p>
         * The type of the timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of the timeout that caused this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityTaskTimeoutType
         */
        Builder timeoutType(String timeoutType);

        /**
         * <p>
         * The type of the timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of the timeout that caused this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityTaskTimeoutType
         */
        Builder timeoutType(ActivityTaskTimeoutType timeoutType);

        /**
         * <p>
         * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * Contains the content of the <code>details</code> parameter for the last call made by the activity to
         * <code>RecordActivityTaskHeartbeat</code>.
         * </p>
         * 
         * @param details
         *        Contains the content of the <code>details</code> parameter for the last call made by the activity to
         *        <code>RecordActivityTaskHeartbeat</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    private static final class BuilderImpl implements Builder {
        private String timeoutType;

        private Long scheduledEventId;

        private Long startedEventId;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskTimedOutEventAttributes model) {
            setTimeoutType(model.timeoutType);
            setScheduledEventId(model.scheduledEventId);
            setStartedEventId(model.startedEventId);
            setDetails(model.details);
        }

        public final String getTimeoutType() {
            return timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(ActivityTaskTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        public final void setTimeoutType(ActivityTaskTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public ActivityTaskTimedOutEventAttributes build() {
            return new ActivityTaskTimedOutEventAttributes(this);
        }
    }
}
