/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ActivityTaskStartedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ActivityTaskStarted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActivityTaskStartedEventAttributes implements StructuredPojo,
        ToCopyableBuilder<ActivityTaskStartedEventAttributes.Builder, ActivityTaskStartedEventAttributes> {
    private final String identity;

    private final Long scheduledEventId;

    private ActivityTaskStartedEventAttributes(BuilderImpl builder) {
        this.identity = builder.identity;
        this.scheduledEventId = builder.scheduledEventId;
    }

    /**
     * <p>
     * Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The form of this
     * identity is user defined.
     * </p>
     * 
     * @return Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The form
     *         of this identity is user defined.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identity() == null) ? 0 : identity().hashCode());
        hashCode = 31 * hashCode + ((scheduledEventId() == null) ? 0 : scheduledEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskStartedEventAttributes)) {
            return false;
        }
        ActivityTaskStartedEventAttributes other = (ActivityTaskStartedEventAttributes) obj;
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.scheduledEventId() == null ^ this.scheduledEventId() == null) {
            return false;
        }
        if (other.scheduledEventId() != null && !other.scheduledEventId().equals(this.scheduledEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        if (scheduledEventId() != null) {
            sb.append("ScheduledEventId: ").append(scheduledEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityTaskStartedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ActivityTaskStartedEventAttributes> {
        /**
         * <p>
         * Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The form of
         * this identity is user defined.
         * </p>
         * 
         * @param identity
         *        Identity of the worker that was assigned this task. This aids diagnostics when problems arise. The
         *        form of this identity is user defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String identity;

        private Long scheduledEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskStartedEventAttributes model) {
            setIdentity(model.identity);
            setScheduledEventId(model.scheduledEventId);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        @Override
        public ActivityTaskStartedEventAttributes build() {
            return new ActivityTaskStartedEventAttributes(this);
        }
    }
}
