/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ActivityTaskScheduledEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ActivityTaskScheduled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActivityTaskScheduledEventAttributes implements StructuredPojo,
        ToCopyableBuilder<ActivityTaskScheduledEventAttributes.Builder, ActivityTaskScheduledEventAttributes> {
    private final ActivityType activityType;

    private final String activityId;

    private final String input;

    private final String control;

    private final String scheduleToStartTimeout;

    private final String scheduleToCloseTimeout;

    private final String startToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final Long decisionTaskCompletedEventId;

    private final String heartbeatTimeout;

    private ActivityTaskScheduledEventAttributes(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.activityId = builder.activityId;
        this.input = builder.input;
        this.control = builder.control;
        this.scheduleToStartTimeout = builder.scheduleToStartTimeout;
        this.scheduleToCloseTimeout = builder.scheduleToCloseTimeout;
        this.startToCloseTimeout = builder.startToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.heartbeatTimeout = builder.heartbeatTimeout;
    }

    /**
     * <p>
     * The type of the activity task.
     * </p>
     * 
     * @return The type of the activity task.
     */
    public ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The unique ID of the activity task.
     * </p>
     * 
     * @return The unique ID of the activity task.
     */
    public String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The input provided to the activity task.
     * </p>
     * 
     * @return The input provided to the activity task.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks. This
     * data is not sent to the activity.
     * </p>
     * 
     * @return Optional.
     */
    public String control() {
        return control;
    }

    /**
     * <p>
     * The maximum amount of time the activity task can wait to be assigned to a worker.
     * </p>
     * 
     * @return The maximum amount of time the activity task can wait to be assigned to a worker.
     */
    public String scheduleToStartTimeout() {
        return scheduleToStartTimeout;
    }

    /**
     * <p>
     * The maximum amount of time for this activity task.
     * </p>
     * 
     * @return The maximum amount of time for this activity task.
     */
    public String scheduleToCloseTimeout() {
        return scheduleToCloseTimeout;
    }

    /**
     * <p>
     * The maximum amount of time a worker may take to process the activity task.
     * </p>
     * 
     * @return The maximum amount of time a worker may take to process the activity task.
     */
    public String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    /**
     * <p>
     * The task list in which the activity task has been scheduled.
     * </p>
     * 
     * @return The task list in which the activity task has been scheduled.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * <i>Optional.</i> The priority to assign to the scheduled activity task. If set, this will override any default
     * priority value that was assigned when the activity type was registered.
     * </p>
     * <p>
     * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return Optional.</i> The priority to assign to the scheduled activity task. If set, this will override any
     *         default priority value that was assigned when the activity type was registered.</p>
     *         <p>
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     *         </p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
     * scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the
     * chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
     *         scheduling of this activity task. This information can be useful for diagnosing problems by tracing back
     *         the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The maximum time before which the worker processing this task must report progress by calling
     * <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out. If
     * the worker subsequently attempts to record a heartbeat or return a result, it will be ignored.
     * </p>
     * 
     * @return The maximum time before which the worker processing this task must report progress by calling
     *         <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed
     *         out. If the worker subsequently attempts to record a heartbeat or return a result, it will be ignored.
     */
    public String heartbeatTimeout() {
        return heartbeatTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activityType() == null) ? 0 : activityType().hashCode());
        hashCode = 31 * hashCode + ((activityId() == null) ? 0 : activityId().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        hashCode = 31 * hashCode + ((scheduleToStartTimeout() == null) ? 0 : scheduleToStartTimeout().hashCode());
        hashCode = 31 * hashCode + ((scheduleToCloseTimeout() == null) ? 0 : scheduleToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((startToCloseTimeout() == null) ? 0 : startToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((taskPriority() == null) ? 0 : taskPriority().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        hashCode = 31 * hashCode + ((heartbeatTimeout() == null) ? 0 : heartbeatTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskScheduledEventAttributes)) {
            return false;
        }
        ActivityTaskScheduledEventAttributes other = (ActivityTaskScheduledEventAttributes) obj;
        if (other.activityType() == null ^ this.activityType() == null) {
            return false;
        }
        if (other.activityType() != null && !other.activityType().equals(this.activityType())) {
            return false;
        }
        if (other.activityId() == null ^ this.activityId() == null) {
            return false;
        }
        if (other.activityId() != null && !other.activityId().equals(this.activityId())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        if (other.scheduleToStartTimeout() == null ^ this.scheduleToStartTimeout() == null) {
            return false;
        }
        if (other.scheduleToStartTimeout() != null && !other.scheduleToStartTimeout().equals(this.scheduleToStartTimeout())) {
            return false;
        }
        if (other.scheduleToCloseTimeout() == null ^ this.scheduleToCloseTimeout() == null) {
            return false;
        }
        if (other.scheduleToCloseTimeout() != null && !other.scheduleToCloseTimeout().equals(this.scheduleToCloseTimeout())) {
            return false;
        }
        if (other.startToCloseTimeout() == null ^ this.startToCloseTimeout() == null) {
            return false;
        }
        if (other.startToCloseTimeout() != null && !other.startToCloseTimeout().equals(this.startToCloseTimeout())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        if (other.heartbeatTimeout() == null ^ this.heartbeatTimeout() == null) {
            return false;
        }
        if (other.heartbeatTimeout() != null && !other.heartbeatTimeout().equals(this.heartbeatTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activityType() != null) {
            sb.append("ActivityType: ").append(activityType()).append(",");
        }
        if (activityId() != null) {
            sb.append("ActivityId: ").append(activityId()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        if (scheduleToStartTimeout() != null) {
            sb.append("ScheduleToStartTimeout: ").append(scheduleToStartTimeout()).append(",");
        }
        if (scheduleToCloseTimeout() != null) {
            sb.append("ScheduleToCloseTimeout: ").append(scheduleToCloseTimeout()).append(",");
        }
        if (startToCloseTimeout() != null) {
            sb.append("StartToCloseTimeout: ").append(startToCloseTimeout()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (taskPriority() != null) {
            sb.append("TaskPriority: ").append(taskPriority()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        if (heartbeatTimeout() != null) {
            sb.append("HeartbeatTimeout: ").append(heartbeatTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityTaskScheduledEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ActivityTaskScheduledEventAttributes> {
        /**
         * <p>
         * The type of the activity task.
         * </p>
         * 
         * @param activityType
         *        The type of the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The unique ID of the activity task.
         * </p>
         * 
         * @param activityId
         *        The unique ID of the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The input provided to the activity task.
         * </p>
         * 
         * @param input
         *        The input provided to the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * This data is not sent to the activity.
         * </p>
         * 
         * @param control
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The maximum amount of time the activity task can wait to be assigned to a worker.
         * </p>
         * 
         * @param scheduleToStartTimeout
         *        The maximum amount of time the activity task can wait to be assigned to a worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToStartTimeout(String scheduleToStartTimeout);

        /**
         * <p>
         * The maximum amount of time for this activity task.
         * </p>
         * 
         * @param scheduleToCloseTimeout
         *        The maximum amount of time for this activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleToCloseTimeout(String scheduleToCloseTimeout);

        /**
         * <p>
         * The maximum amount of time a worker may take to process the activity task.
         * </p>
         * 
         * @param startToCloseTimeout
         *        The maximum amount of time a worker may take to process the activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);

        /**
         * <p>
         * The task list in which the activity task has been scheduled.
         * </p>
         * 
         * @param taskList
         *        The task list in which the activity task has been scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * <i>Optional.</i> The priority to assign to the scheduled activity task. If set, this will override any
         * default priority value that was assigned when the activity type was registered.
         * </p>
         * <p>
         * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        Optional.</i> The priority to assign to the scheduled activity task. If set, this will override any
         *        default priority value that was assigned when the activity type was registered.</p>
         *        <p>
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         *        </p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in the
         * scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the
         * chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision that resulted in
         *        the scheduling of this activity task. This information can be useful for diagnosing problems by
         *        tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         * <p>
         * The maximum time before which the worker processing this task must report progress by calling
         * <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically timed out.
         * If the worker subsequently attempts to record a heartbeat or return a result, it will be ignored.
         * </p>
         * 
         * @param heartbeatTimeout
         *        The maximum time before which the worker processing this task must report progress by calling
         *        <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is automatically
         *        timed out. If the worker subsequently attempts to record a heartbeat or return a result, it will be
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatTimeout(String heartbeatTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private ActivityType activityType;

        private String activityId;

        private String input;

        private String control;

        private String scheduleToStartTimeout;

        private String scheduleToCloseTimeout;

        private String startToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private Long decisionTaskCompletedEventId;

        private String heartbeatTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskScheduledEventAttributes model) {
            setActivityType(model.activityType);
            setActivityId(model.activityId);
            setInput(model.input);
            setControl(model.control);
            setScheduleToStartTimeout(model.scheduleToStartTimeout);
            setScheduleToCloseTimeout(model.scheduleToCloseTimeout);
            setStartToCloseTimeout(model.startToCloseTimeout);
            setTaskList(model.taskList);
            setTaskPriority(model.taskPriority);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            setHeartbeatTimeout(model.heartbeatTimeout);
        }

        public final ActivityType getActivityType() {
            return activityType;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType activityType) {
            this.activityType = activityType;
        }

        public final String getActivityId() {
            return activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getScheduleToStartTimeout() {
            return scheduleToStartTimeout;
        }

        @Override
        public final Builder scheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            return this;
        }

        public final void setScheduleToStartTimeout(String scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
        }

        public final String getScheduleToCloseTimeout() {
            return scheduleToCloseTimeout;
        }

        @Override
        public final Builder scheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        public final void setScheduleToCloseTimeout(String scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getHeartbeatTimeout() {
            return heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final void setHeartbeatTimeout(String heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        @Override
        public ActivityTaskScheduledEventAttributes build() {
            return new ActivityTaskScheduledEventAttributes(this);
        }
    }
}
