/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ActivityTaskCompletedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ActivityTaskCompleted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActivityTaskCompletedEventAttributes implements StructuredPojo,
        ToCopyableBuilder<ActivityTaskCompletedEventAttributes.Builder, ActivityTaskCompletedEventAttributes> {
    private final String result;

    private final Long scheduledEventId;

    private final Long startedEventId;

    private ActivityTaskCompletedEventAttributes(BuilderImpl builder) {
        this.result = builder.result;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
    }

    /**
     * <p>
     * The results of the activity task (if any).
     * </p>
     * 
     * @return The results of the activity task (if any).
     */
    public String result() {
        return result;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
     *         scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
     *         leading up to this event.
     */
    public Long scheduledEventId() {
        return scheduledEventId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((result() == null) ? 0 : result().hashCode());
        hashCode = 31 * hashCode + ((scheduledEventId() == null) ? 0 : scheduledEventId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTaskCompletedEventAttributes)) {
            return false;
        }
        ActivityTaskCompletedEventAttributes other = (ActivityTaskCompletedEventAttributes) obj;
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.scheduledEventId() == null ^ this.scheduledEventId() == null) {
            return false;
        }
        if (other.scheduledEventId() != null && !other.scheduledEventId().equals(this.scheduledEventId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (result() != null) {
            sb.append("Result: ").append(result()).append(",");
        }
        if (scheduledEventId() != null) {
            sb.append("ScheduledEventId: ").append(scheduledEventId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityTaskCompletedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ActivityTaskCompletedEventAttributes> {
        /**
         * <p>
         * The results of the activity task (if any).
         * </p>
         * 
         * @param result
         *        The results of the activity task (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         * scheduled. This information can be useful for diagnosing problems by tracing back the chain of events leading
         * up to this event.
         * </p>
         * 
         * @param scheduledEventId
         *        The ID of the <code>ActivityTaskScheduled</code> event that was recorded when this activity task was
         *        scheduled. This information can be useful for diagnosing problems by tracing back the chain of events
         *        leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledEventId(Long scheduledEventId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event recorded when this activity task was started.
         *        This information can be useful for diagnosing problems by tracing back the chain of events leading up
         *        to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String result;

        private Long scheduledEventId;

        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTaskCompletedEventAttributes model) {
            setResult(model.result);
            setScheduledEventId(model.scheduledEventId);
            setStartedEventId(model.startedEventId);
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final Long getScheduledEventId() {
            return scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        @Override
        public ActivityTaskCompletedEventAttributes build() {
            return new ActivityTaskCompletedEventAttributes(this);
        }
    }
}
