/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.signer.model.SignatureValidityPeriod;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningParametersCopier;
import software.amazon.awssdk.services.signer.model.SigningProfileStatus;
import software.amazon.awssdk.services.signer.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningProfile> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(SigningProfile.getter(SigningProfile::profileName)).setter(SigningProfile.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersion").getter(SigningProfile.getter(SigningProfile::profileVersion)).setter(SigningProfile.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersionArn").getter(SigningProfile.getter(SigningProfile::profileVersionArn)).setter(SigningProfile.setter(Builder::profileVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersionArn").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingMaterial").getter(SigningProfile.getter(SigningProfile::signingMaterial)).setter(SigningProfile.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<SignatureValidityPeriod> SIGNATURE_VALIDITY_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signatureValidityPeriod").getter(SigningProfile.getter(SigningProfile::signatureValidityPeriod)).setter(SigningProfile.setter(Builder::signatureValidityPeriod)).constructor(SignatureValidityPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureValidityPeriod").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(SigningProfile.getter(SigningProfile::platformId)).setter(SigningProfile.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<String> PLATFORM_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformDisplayName").getter(SigningProfile.getter(SigningProfile::platformDisplayName)).setter(SigningProfile.setter(Builder::platformDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDisplayName").build()}).build();
    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("signingParameters").getter(SigningProfile.getter(SigningProfile::signingParameters)).setter(SigningProfile.setter(Builder::signingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SigningProfile.getter(SigningProfile::statusAsString)).setter(SigningProfile.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SigningProfile.getter(SigningProfile::arn)).setter(SigningProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SigningProfile.getter(SigningProfile::tags)).setter(SigningProfile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, PROFILE_VERSION_FIELD, PROFILE_VERSION_ARN_FIELD, SIGNING_MATERIAL_FIELD, SIGNATURE_VALIDITY_PERIOD_FIELD, PLATFORM_ID_FIELD, PLATFORM_DISPLAY_NAME_FIELD, SIGNING_PARAMETERS_FIELD, STATUS_FIELD, ARN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profileName;
    private final String profileVersion;
    private final String profileVersionArn;
    private final SigningMaterial signingMaterial;
    private final SignatureValidityPeriod signatureValidityPeriod;
    private final String platformId;
    private final String platformDisplayName;
    private final Map<String, String> signingParameters;
    private final String status;
    private final String arn;
    private final Map<String, String> tags;

    private SigningProfile(BuilderImpl builder) {
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.profileVersionArn = builder.profileVersionArn;
        this.signingMaterial = builder.signingMaterial;
        this.signatureValidityPeriod = builder.signatureValidityPeriod;
        this.platformId = builder.platformId;
        this.platformDisplayName = builder.platformDisplayName;
        this.signingParameters = builder.signingParameters;
        this.status = builder.status;
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileVersion() {
        return this.profileVersion;
    }

    public final String profileVersionArn() {
        return this.profileVersionArn;
    }

    public final SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public final SignatureValidityPeriod signatureValidityPeriod() {
        return this.signatureValidityPeriod;
    }

    public final String platformId() {
        return this.platformId;
    }

    public final String platformDisplayName() {
        return this.platformDisplayName;
    }

    public final boolean hasSigningParameters() {
        return this.signingParameters != null && !(this.signingParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> signingParameters() {
        return this.signingParameters;
    }

    public final SigningProfileStatus status() {
        return SigningProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureValidityPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigningParameters() ? this.signingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningProfile)) {
            return false;
        }
        SigningProfile other = (SigningProfile)obj;
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileVersion(), other.profileVersion()) && Objects.equals(this.profileVersionArn(), other.profileVersionArn()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.signatureValidityPeriod(), other.signatureValidityPeriod()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.platformDisplayName(), other.platformDisplayName()) && this.hasSigningParameters() == other.hasSigningParameters() && Objects.equals(this.signingParameters(), other.signingParameters()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SigningProfile").add("ProfileName", (Object)this.profileName()).add("ProfileVersion", (Object)this.profileVersion()).add("ProfileVersionArn", (Object)this.profileVersionArn()).add("SigningMaterial", (Object)this.signingMaterial()).add("SignatureValidityPeriod", (Object)this.signatureValidityPeriod()).add("PlatformId", (Object)this.platformId()).add("PlatformDisplayName", (Object)this.platformDisplayName()).add("SigningParameters", this.hasSigningParameters() ? this.signingParameters() : null).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
            case "profileVersionArn": {
                return Optional.ofNullable(clazz.cast(this.profileVersionArn()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "signatureValidityPeriod": {
                return Optional.ofNullable(clazz.cast(this.signatureValidityPeriod()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "platformDisplayName": {
                return Optional.ofNullable(clazz.cast(this.platformDisplayName()));
            }
            case "signingParameters": {
                return Optional.ofNullable(clazz.cast(this.signingParameters()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningProfile, T> g) {
        return obj -> g.apply((SigningProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileName;
        private String profileVersion;
        private String profileVersionArn;
        private SigningMaterial signingMaterial;
        private SignatureValidityPeriod signatureValidityPeriod;
        private String platformId;
        private String platformDisplayName;
        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String arn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SigningProfile model) {
            this.profileName(model.profileName);
            this.profileVersion(model.profileVersion);
            this.profileVersionArn(model.profileVersionArn);
            this.signingMaterial(model.signingMaterial);
            this.signatureValidityPeriod(model.signatureValidityPeriod);
            this.platformId(model.platformId);
            this.platformDisplayName(model.platformDisplayName);
            this.signingParameters(model.signingParameters);
            this.status(model.status);
            this.arn(model.arn);
            this.tags(model.tags);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final String getProfileVersionArn() {
            return this.profileVersionArn;
        }

        public final void setProfileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
        }

        @Override
        public final Builder profileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
            return this;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final SignatureValidityPeriod.Builder getSignatureValidityPeriod() {
            return this.signatureValidityPeriod != null ? this.signatureValidityPeriod.toBuilder() : null;
        }

        public final void setSignatureValidityPeriod(SignatureValidityPeriod.BuilderImpl signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod != null ? signatureValidityPeriod.build() : null;
        }

        @Override
        public final Builder signatureValidityPeriod(SignatureValidityPeriod signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod;
            return this;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getPlatformDisplayName() {
            return this.platformDisplayName;
        }

        public final void setPlatformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
        }

        @Override
        public final Builder platformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
            return this;
        }

        public final Map<String, String> getSigningParameters() {
            if (this.signingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.signingParameters;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public SigningProfile build() {
            return new SigningProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningProfile> {
        public Builder profileName(String var1);

        public Builder profileVersion(String var1);

        public Builder profileVersionArn(String var1);

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder signatureValidityPeriod(SignatureValidityPeriod var1);

        default public Builder signatureValidityPeriod(Consumer<SignatureValidityPeriod.Builder> signatureValidityPeriod) {
            return this.signatureValidityPeriod((SignatureValidityPeriod)((SignatureValidityPeriod.Builder)SignatureValidityPeriod.builder().applyMutation(signatureValidityPeriod)).build());
        }

        public Builder platformId(String var1);

        public Builder platformDisplayName(String var1);

        public Builder signingParameters(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(SigningProfileStatus var1);

        public Builder arn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

