/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSigningProfileRequest extends SignerRequest implements
        ToCopyableBuilder<PutSigningProfileRequest.Builder, PutSigningProfileRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(PutSigningProfileRequest::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileName").build()).build();

    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField
            .<SigningMaterial> builder(MarshallingType.SDK_POJO).memberName("signingMaterial")
            .getter(getter(PutSigningProfileRequest::signingMaterial)).setter(setter(Builder::signingMaterial))
            .constructor(SigningMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()).build();

    private static final SdkField<SignatureValidityPeriod> SIGNATURE_VALIDITY_PERIOD_FIELD = SdkField
            .<SignatureValidityPeriod> builder(MarshallingType.SDK_POJO).memberName("signatureValidityPeriod")
            .getter(getter(PutSigningProfileRequest::signatureValidityPeriod)).setter(setter(Builder::signatureValidityPeriod))
            .constructor(SignatureValidityPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureValidityPeriod").build())
            .build();

    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformId").getter(getter(PutSigningProfileRequest::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()).build();

    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField
            .<SigningPlatformOverrides> builder(MarshallingType.SDK_POJO).memberName("overrides")
            .getter(getter(PutSigningProfileRequest::overrides)).setter(setter(Builder::overrides))
            .constructor(SigningPlatformOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()).build();

    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("signingParameters")
            .getter(getter(PutSigningProfileRequest::signingParameters))
            .setter(setter(Builder::signingParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PutSigningProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD,
            SIGNING_MATERIAL_FIELD, SIGNATURE_VALIDITY_PERIOD_FIELD, PLATFORM_ID_FIELD, OVERRIDES_FIELD,
            SIGNING_PARAMETERS_FIELD, TAGS_FIELD));

    private final String profileName;

    private final SigningMaterial signingMaterial;

    private final SignatureValidityPeriod signatureValidityPeriod;

    private final String platformId;

    private final SigningPlatformOverrides overrides;

    private final Map<String, String> signingParameters;

    private final Map<String, String> tags;

    private PutSigningProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.signingMaterial = builder.signingMaterial;
        this.signatureValidityPeriod = builder.signatureValidityPeriod;
        this.platformId = builder.platformId;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the signing profile to be created.
     * </p>
     * 
     * @return The name of the signing profile to be created.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.
     * </p>
     * 
     * @return The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.
     */
    public final SigningMaterial signingMaterial() {
        return signingMaterial;
    }

    /**
     * <p>
     * The default validity period override for any signature generated using this signing profile. If unspecified, the
     * default is 135 months.
     * </p>
     * 
     * @return The default validity period override for any signature generated using this signing profile. If
     *         unspecified, the default is 135 months.
     */
    public final SignatureValidityPeriod signatureValidityPeriod() {
        return signatureValidityPeriod;
    }

    /**
     * <p>
     * The ID of the signing platform to be created.
     * </p>
     * 
     * @return The ID of the signing platform to be created.
     */
    public final String platformId() {
        return platformId;
    }

    /**
     * <p>
     * A subfield of <code>platform</code>. This specifies any different configuration options that you want to apply to
     * the chosen platform (such as a different <code>hash-algorithm</code> or <code>signing-algorithm</code>).
     * </p>
     * 
     * @return A subfield of <code>platform</code>. This specifies any different configuration options that you want to
     *         apply to the chosen platform (such as a different <code>hash-algorithm</code> or
     *         <code>signing-algorithm</code>).
     */
    public final SigningPlatformOverrides overrides() {
        return overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the SigningParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSigningParameters() {
        return signingParameters != null && !(signingParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of key-value pairs for signing. These can include any information that you want to use during signing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSigningParameters} method.
     * </p>
     * 
     * @return Map of key-value pairs for signing. These can include any information that you want to use during
     *         signing.
     */
    public final Map<String, String> signingParameters() {
        return signingParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to be associated with the signing profile that is being created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be associated with the signing profile that is being created.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(signatureValidityPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(overrides());
        hashCode = 31 * hashCode + Objects.hashCode(hasSigningParameters() ? signingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSigningProfileRequest)) {
            return false;
        }
        PutSigningProfileRequest other = (PutSigningProfileRequest) obj;
        return Objects.equals(profileName(), other.profileName()) && Objects.equals(signingMaterial(), other.signingMaterial())
                && Objects.equals(signatureValidityPeriod(), other.signatureValidityPeriod())
                && Objects.equals(platformId(), other.platformId()) && Objects.equals(overrides(), other.overrides())
                && hasSigningParameters() == other.hasSigningParameters()
                && Objects.equals(signingParameters(), other.signingParameters()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSigningProfileRequest").add("ProfileName", profileName())
                .add("SigningMaterial", signingMaterial()).add("SignatureValidityPeriod", signatureValidityPeriod())
                .add("PlatformId", platformId()).add("Overrides", overrides())
                .add("SigningParameters", hasSigningParameters() ? signingParameters() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "signingMaterial":
            return Optional.ofNullable(clazz.cast(signingMaterial()));
        case "signatureValidityPeriod":
            return Optional.ofNullable(clazz.cast(signatureValidityPeriod()));
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "signingParameters":
            return Optional.ofNullable(clazz.cast(signingParameters()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSigningProfileRequest, T> g) {
        return obj -> g.apply((PutSigningProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutSigningProfileRequest> {
        /**
         * <p>
         * The name of the signing profile to be created.
         * </p>
         * 
         * @param profileName
         *        The name of the signing profile to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.
         * </p>
         * 
         * @param signingMaterial
         *        The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingMaterial(SigningMaterial signingMaterial);

        /**
         * <p>
         * The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningMaterial.Builder} avoiding the need to
         * create one manually via {@link SigningMaterial#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningMaterial.Builder#build()} is called immediately and its
         * result is passed to {@link #signingMaterial(SigningMaterial)}.
         * 
         * @param signingMaterial
         *        a consumer that will call methods on {@link SigningMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingMaterial(SigningMaterial)
         */
        default Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return signingMaterial(SigningMaterial.builder().applyMutation(signingMaterial).build());
        }

        /**
         * <p>
         * The default validity period override for any signature generated using this signing profile. If unspecified,
         * the default is 135 months.
         * </p>
         * 
         * @param signatureValidityPeriod
         *        The default validity period override for any signature generated using this signing profile. If
         *        unspecified, the default is 135 months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureValidityPeriod(SignatureValidityPeriod signatureValidityPeriod);

        /**
         * <p>
         * The default validity period override for any signature generated using this signing profile. If unspecified,
         * the default is 135 months.
         * </p>
         * This is a convenience that creates an instance of the {@link SignatureValidityPeriod.Builder} avoiding the
         * need to create one manually via {@link SignatureValidityPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link SignatureValidityPeriod.Builder#build()} is called immediately
         * and its result is passed to {@link #signatureValidityPeriod(SignatureValidityPeriod)}.
         * 
         * @param signatureValidityPeriod
         *        a consumer that will call methods on {@link SignatureValidityPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signatureValidityPeriod(SignatureValidityPeriod)
         */
        default Builder signatureValidityPeriod(Consumer<SignatureValidityPeriod.Builder> signatureValidityPeriod) {
            return signatureValidityPeriod(SignatureValidityPeriod.builder().applyMutation(signatureValidityPeriod).build());
        }

        /**
         * <p>
         * The ID of the signing platform to be created.
         * </p>
         * 
         * @param platformId
         *        The ID of the signing platform to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * A subfield of <code>platform</code>. This specifies any different configuration options that you want to
         * apply to the chosen platform (such as a different <code>hash-algorithm</code> or
         * <code>signing-algorithm</code>).
         * </p>
         * 
         * @param overrides
         *        A subfield of <code>platform</code>. This specifies any different configuration options that you want
         *        to apply to the chosen platform (such as a different <code>hash-algorithm</code> or
         *        <code>signing-algorithm</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(SigningPlatformOverrides overrides);

        /**
         * <p>
         * A subfield of <code>platform</code>. This specifies any different configuration options that you want to
         * apply to the chosen platform (such as a different <code>hash-algorithm</code> or
         * <code>signing-algorithm</code>).
         * </p>
         * This is a convenience that creates an instance of the {@link SigningPlatformOverrides.Builder} avoiding the
         * need to create one manually via {@link SigningPlatformOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningPlatformOverrides.Builder#build()} is called immediately
         * and its result is passed to {@link #overrides(SigningPlatformOverrides)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link SigningPlatformOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(SigningPlatformOverrides)
         */
        default Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return overrides(SigningPlatformOverrides.builder().applyMutation(overrides).build());
        }

        /**
         * <p>
         * Map of key-value pairs for signing. These can include any information that you want to use during signing.
         * </p>
         * 
         * @param signingParameters
         *        Map of key-value pairs for signing. These can include any information that you want to use during
         *        signing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingParameters(Map<String, String> signingParameters);

        /**
         * <p>
         * Tags to be associated with the signing profile that is being created.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the signing profile that is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SignerRequest.BuilderImpl implements Builder {
        private String profileName;

        private SigningMaterial signingMaterial;

        private SignatureValidityPeriod signatureValidityPeriod;

        private String platformId;

        private SigningPlatformOverrides overrides;

        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSigningProfileRequest model) {
            super(model);
            profileName(model.profileName);
            signingMaterial(model.signingMaterial);
            signatureValidityPeriod(model.signatureValidityPeriod);
            platformId(model.platformId);
            overrides(model.overrides);
            signingParameters(model.signingParameters);
            tags(model.tags);
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        @Transient
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return signingMaterial != null ? signingMaterial.toBuilder() : null;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        @Override
        @Transient
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final SignatureValidityPeriod.Builder getSignatureValidityPeriod() {
            return signatureValidityPeriod != null ? signatureValidityPeriod.toBuilder() : null;
        }

        public final void setSignatureValidityPeriod(SignatureValidityPeriod.BuilderImpl signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod != null ? signatureValidityPeriod.build() : null;
        }

        @Override
        @Transient
        public final Builder signatureValidityPeriod(SignatureValidityPeriod signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod;
            return this;
        }

        public final String getPlatformId() {
            return platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        @Transient
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return overrides != null ? overrides.toBuilder() : null;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        @Transient
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final Map<String, String> getSigningParameters() {
            if (signingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return signingParameters;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        @Override
        @Transient
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSigningProfileRequest build() {
            return new PutSigningProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
