/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Revocation information for a signing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningProfileRevocationRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningProfileRevocationRecord.Builder, SigningProfileRevocationRecord> {
    private static final SdkField<Instant> REVOCATION_EFFECTIVE_FROM_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("revocationEffectiveFrom").getter(getter(SigningProfileRevocationRecord::revocationEffectiveFrom))
            .setter(setter(Builder::revocationEffectiveFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationEffectiveFrom").build())
            .build();

    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("revokedAt").getter(getter(SigningProfileRevocationRecord::revokedAt)).setter(setter(Builder::revokedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedAt").build()).build();

    private static final SdkField<String> REVOKED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revokedBy").getter(getter(SigningProfileRevocationRecord::revokedBy)).setter(setter(Builder::revokedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REVOCATION_EFFECTIVE_FROM_FIELD, REVOKED_AT_FIELD, REVOKED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant revocationEffectiveFrom;

    private final Instant revokedAt;

    private final String revokedBy;

    private SigningProfileRevocationRecord(BuilderImpl builder) {
        this.revocationEffectiveFrom = builder.revocationEffectiveFrom;
        this.revokedAt = builder.revokedAt;
        this.revokedBy = builder.revokedBy;
    }

    /**
     * <p>
     * The time when revocation becomes effective.
     * </p>
     * 
     * @return The time when revocation becomes effective.
     */
    public final Instant revocationEffectiveFrom() {
        return revocationEffectiveFrom;
    }

    /**
     * <p>
     * The time when the signing profile was revoked.
     * </p>
     * 
     * @return The time when the signing profile was revoked.
     */
    public final Instant revokedAt() {
        return revokedAt;
    }

    /**
     * <p>
     * The identity of the revoker.
     * </p>
     * 
     * @return The identity of the revoker.
     */
    public final String revokedBy() {
        return revokedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revocationEffectiveFrom());
        hashCode = 31 * hashCode + Objects.hashCode(revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(revokedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningProfileRevocationRecord)) {
            return false;
        }
        SigningProfileRevocationRecord other = (SigningProfileRevocationRecord) obj;
        return Objects.equals(revocationEffectiveFrom(), other.revocationEffectiveFrom())
                && Objects.equals(revokedAt(), other.revokedAt()) && Objects.equals(revokedBy(), other.revokedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningProfileRevocationRecord").add("RevocationEffectiveFrom", revocationEffectiveFrom())
                .add("RevokedAt", revokedAt()).add("RevokedBy", revokedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revocationEffectiveFrom":
            return Optional.ofNullable(clazz.cast(revocationEffectiveFrom()));
        case "revokedAt":
            return Optional.ofNullable(clazz.cast(revokedAt()));
        case "revokedBy":
            return Optional.ofNullable(clazz.cast(revokedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningProfileRevocationRecord, T> g) {
        return obj -> g.apply((SigningProfileRevocationRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningProfileRevocationRecord> {
        /**
         * <p>
         * The time when revocation becomes effective.
         * </p>
         * 
         * @param revocationEffectiveFrom
         *        The time when revocation becomes effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationEffectiveFrom(Instant revocationEffectiveFrom);

        /**
         * <p>
         * The time when the signing profile was revoked.
         * </p>
         * 
         * @param revokedAt
         *        The time when the signing profile was revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedAt(Instant revokedAt);

        /**
         * <p>
         * The identity of the revoker.
         * </p>
         * 
         * @param revokedBy
         *        The identity of the revoker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedBy(String revokedBy);
    }

    static final class BuilderImpl implements Builder {
        private Instant revocationEffectiveFrom;

        private Instant revokedAt;

        private String revokedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningProfileRevocationRecord model) {
            revocationEffectiveFrom(model.revocationEffectiveFrom);
            revokedAt(model.revokedAt);
            revokedBy(model.revokedBy);
        }

        public final Instant getRevocationEffectiveFrom() {
            return revocationEffectiveFrom;
        }

        @Override
        public final Builder revocationEffectiveFrom(Instant revocationEffectiveFrom) {
            this.revocationEffectiveFrom = revocationEffectiveFrom;
            return this;
        }

        public final void setRevocationEffectiveFrom(Instant revocationEffectiveFrom) {
            this.revocationEffectiveFrom = revocationEffectiveFrom;
        }

        public final Instant getRevokedAt() {
            return revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        public final String getRevokedBy() {
            return revokedBy;
        }

        @Override
        public final Builder revokedBy(String revokedBy) {
            this.revokedBy = revokedBy;
            return this;
        }

        public final void setRevokedBy(String revokedBy) {
            this.revokedBy = revokedBy;
        }

        @Override
        public SigningProfileRevocationRecord build() {
            return new SigningProfileRevocationRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
