/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeSigningProfileRequest extends SignerRequest implements
        ToCopyableBuilder<RevokeSigningProfileRequest.Builder, RevokeSigningProfileRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(RevokeSigningProfileRequest::profileName))
            .setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileName").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersion").getter(getter(RevokeSigningProfileRequest::profileVersion))
            .setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(RevokeSigningProfileRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<Instant> EFFECTIVE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("effectiveTime").getter(getter(RevokeSigningProfileRequest::effectiveTime))
            .setter(setter(Builder::effectiveTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD,
            PROFILE_VERSION_FIELD, REASON_FIELD, EFFECTIVE_TIME_FIELD));

    private final String profileName;

    private final String profileVersion;

    private final String reason;

    private final Instant effectiveTime;

    private RevokeSigningProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.reason = builder.reason;
        this.effectiveTime = builder.effectiveTime;
    }

    /**
     * <p>
     * The name of the signing profile to be revoked.
     * </p>
     * 
     * @return The name of the signing profile to be revoked.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The version of the signing profile to be revoked.
     * </p>
     * 
     * @return The version of the signing profile to be revoked.
     */
    public final String profileVersion() {
        return profileVersion;
    }

    /**
     * <p>
     * The reason for revoking a signing profile.
     * </p>
     * 
     * @return The reason for revoking a signing profile.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using the
     * signing profile after this timestamp are not trusted.
     * </p>
     * 
     * @return A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using
     *         the signing profile after this timestamp are not trusted.
     */
    public final Instant effectiveTime() {
        return effectiveTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSigningProfileRequest)) {
            return false;
        }
        RevokeSigningProfileRequest other = (RevokeSigningProfileRequest) obj;
        return Objects.equals(profileName(), other.profileName()) && Objects.equals(profileVersion(), other.profileVersion())
                && Objects.equals(reason(), other.reason()) && Objects.equals(effectiveTime(), other.effectiveTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeSigningProfileRequest").add("ProfileName", profileName())
                .add("ProfileVersion", profileVersion()).add("Reason", reason()).add("EffectiveTime", effectiveTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "profileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "effectiveTime":
            return Optional.ofNullable(clazz.cast(effectiveTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSigningProfileRequest, T> g) {
        return obj -> g.apply((RevokeSigningProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerRequest.Builder, SdkPojo, CopyableBuilder<Builder, RevokeSigningProfileRequest> {
        /**
         * <p>
         * The name of the signing profile to be revoked.
         * </p>
         * 
         * @param profileName
         *        The name of the signing profile to be revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The version of the signing profile to be revoked.
         * </p>
         * 
         * @param profileVersion
         *        The version of the signing profile to be revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);

        /**
         * <p>
         * The reason for revoking a signing profile.
         * </p>
         * 
         * @param reason
         *        The reason for revoking a signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using the
         * signing profile after this timestamp are not trusted.
         * </p>
         * 
         * @param effectiveTime
         *        A timestamp for when revocation of a Signing Profile should become effective. Signatures generated
         *        using the signing profile after this timestamp are not trusted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveTime(Instant effectiveTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SignerRequest.BuilderImpl implements Builder {
        private String profileName;

        private String profileVersion;

        private String reason;

        private Instant effectiveTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSigningProfileRequest model) {
            super(model);
            profileName(model.profileName);
            profileVersion(model.profileVersion);
            reason(model.reason);
            effectiveTime(model.effectiveTime);
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Instant getEffectiveTime() {
            return effectiveTime;
        }

        @Override
        public final Builder effectiveTime(Instant effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }

        public final void setEffectiveTime(Instant effectiveTime) {
            this.effectiveTime = effectiveTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeSigningProfileRequest build() {
            return new RevokeSigningProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
