/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSigningProfileResponse extends SignerResponse implements
        ToCopyableBuilder<PutSigningProfileResponse.Builder, PutSigningProfileResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(PutSigningProfileResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersion").getter(getter(PutSigningProfileResponse::profileVersion))
            .setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()).build();

    private static final SdkField<String> PROFILE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersionArn").getter(getter(PutSigningProfileResponse::profileVersionArn))
            .setter(setter(Builder::profileVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            PROFILE_VERSION_FIELD, PROFILE_VERSION_ARN_FIELD));

    private final String arn;

    private final String profileVersion;

    private final String profileVersionArn;

    private PutSigningProfileResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.profileVersion = builder.profileVersion;
        this.profileVersionArn = builder.profileVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the signing profile created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the signing profile created.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The version of the signing profile being created.
     * </p>
     * 
     * @return The version of the signing profile being created.
     */
    public String profileVersion() {
        return profileVersion;
    }

    /**
     * <p>
     * The signing profile ARN, including the profile version.
     * </p>
     * 
     * @return The signing profile ARN, including the profile version.
     */
    public String profileVersionArn() {
        return profileVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSigningProfileResponse)) {
            return false;
        }
        PutSigningProfileResponse other = (PutSigningProfileResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(profileVersion(), other.profileVersion())
                && Objects.equals(profileVersionArn(), other.profileVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutSigningProfileResponse").add("Arn", arn()).add("ProfileVersion", profileVersion())
                .add("ProfileVersionArn", profileVersionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "profileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        case "profileVersionArn":
            return Optional.ofNullable(clazz.cast(profileVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSigningProfileResponse, T> g) {
        return obj -> g.apply((PutSigningProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSigningProfileResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the signing profile created.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the signing profile created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The version of the signing profile being created.
         * </p>
         * 
         * @param profileVersion
         *        The version of the signing profile being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);

        /**
         * <p>
         * The signing profile ARN, including the profile version.
         * </p>
         * 
         * @param profileVersionArn
         *        The signing profile ARN, including the profile version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersionArn(String profileVersionArn);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private String arn;

        private String profileVersion;

        private String profileVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSigningProfileResponse model) {
            super(model);
            arn(model.arn);
            profileVersion(model.profileVersion);
            profileVersionArn(model.profileVersionArn);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        public final String getProfileVersionArn() {
            return profileVersionArn;
        }

        @Override
        public final Builder profileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
            return this;
        }

        public final void setProfileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
        }

        @Override
        public PutSigningProfileResponse build() {
            return new PutSigningProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
