/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSigningProfilesResponse extends SignerResponse implements
        ToCopyableBuilder<ListSigningProfilesResponse.Builder, ListSigningProfilesResponse> {
    private static final SdkField<List<SigningProfile>> PROFILES_FIELD = SdkField
            .<List<SigningProfile>> builder(MarshallingType.LIST)
            .memberName("profiles")
            .getter(getter(ListSigningProfilesResponse::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SigningProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(SigningProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSigningProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SigningProfile> profiles;

    private final String nextToken;

    private ListSigningProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.profiles = builder.profiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Profiles property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of profiles that are available in the AWS account. This includes profiles with the status of
     * <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of profiles that are available in the AWS account. This includes profiles with the status of
     *         <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.
     */
    public List<SigningProfile> profiles() {
        return profiles;
    }

    /**
     * <p>
     * Value for specifying the next set of paginated results to return.
     * </p>
     * 
     * @return Value for specifying the next set of paginated results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningProfilesResponse)) {
            return false;
        }
        ListSigningProfilesResponse other = (ListSigningProfilesResponse) obj;
        return hasProfiles() == other.hasProfiles() && Objects.equals(profiles(), other.profiles())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSigningProfilesResponse").add("Profiles", hasProfiles() ? profiles() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSigningProfilesResponse, T> g) {
        return obj -> g.apply((ListSigningProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSigningProfilesResponse> {
        /**
         * <p>
         * A list of profiles that are available in the AWS account. This includes profiles with the status of
         * <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.
         * </p>
         * 
         * @param profiles
         *        A list of profiles that are available in the AWS account. This includes profiles with the status of
         *        <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<SigningProfile> profiles);

        /**
         * <p>
         * A list of profiles that are available in the AWS account. This includes profiles with the status of
         * <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.
         * </p>
         * 
         * @param profiles
         *        A list of profiles that are available in the AWS account. This includes profiles with the status of
         *        <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(SigningProfile... profiles);

        /**
         * <p>
         * A list of profiles that are available in the AWS account. This includes profiles with the status of
         * <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SigningProfile>.Builder} avoiding the need
         * to create one manually via {@link List<SigningProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SigningProfile>.Builder#build()} is called immediately and
         * its result is passed to {@link #profiles(List<SigningProfile>)}.
         * 
         * @param profiles
         *        a consumer that will call methods on {@link List<SigningProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profiles(List<SigningProfile>)
         */
        Builder profiles(Consumer<SigningProfile.Builder>... profiles);

        /**
         * <p>
         * Value for specifying the next set of paginated results to return.
         * </p>
         * 
         * @param nextToken
         *        Value for specifying the next set of paginated results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private List<SigningProfile> profiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningProfilesResponse model) {
            super(model);
            profiles(model.profiles);
            nextToken(model.nextToken);
        }

        public final Collection<SigningProfile.Builder> getProfiles() {
            if (profiles instanceof SdkAutoConstructList) {
                return null;
            }
            return profiles != null ? profiles.stream().map(SigningProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder profiles(Collection<SigningProfile> profiles) {
            this.profiles = SigningProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(SigningProfile... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<SigningProfile.Builder>... profiles) {
            profiles(Stream.of(profiles).map(c -> SigningProfile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProfiles(Collection<SigningProfile.BuilderImpl> profiles) {
            this.profiles = SigningProfilesCopier.copyFromBuilder(profiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSigningProfilesResponse build() {
            return new ListSigningProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
