/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.shield.ShieldClient;
import software.amazon.awssdk.services.shield.model.AttackSummary;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;

public class ListAttacksIterable
implements SdkIterable<ListAttacksResponse> {
    private final ShieldClient client;
    private final ListAttacksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttacksIterable(ShieldClient client, ListAttacksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttacksResponseFetcher();
    }

    public Iterator<ListAttacksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttackSummary> attackSummaries() {
        Function<ListAttacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.attackSummaries() != null) {
                return response.attackSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttacksResponseFetcher
    implements SyncPageFetcher<ListAttacksResponse> {
        private ListAttacksResponseFetcher() {
        }

        public boolean hasNextPage(ListAttacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttacksResponse nextPage(ListAttacksResponse previousPage) {
            if (previousPage == null) {
                return ListAttacksIterable.this.client.listAttacks(ListAttacksIterable.this.firstRequest);
            }
            return ListAttacksIterable.this.client.listAttacks((ListAttacksRequest)((Object)ListAttacksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

