/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportSourceType {
    METRICS_DATA("METRICS_DATA"),
    MESSAGE_INSIGHTS("MESSAGE_INSIGHTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportSourceType> VALUE_MAP;
    private final String value;

    private ExportSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportSourceType> knownValues() {
        EnumSet<ExportSourceType> knownValues = EnumSet.allOf(ExportSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportSourceType.class, ExportSourceType::toString);
    }
}

