/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VerificationError {
    SERVICE_ERROR("SERVICE_ERROR"),
    DNS_SERVER_ERROR("DNS_SERVER_ERROR"),
    HOST_NOT_FOUND("HOST_NOT_FOUND"),
    TYPE_NOT_FOUND("TYPE_NOT_FOUND"),
    INVALID_VALUE("INVALID_VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VerificationError> VALUE_MAP;
    private final String value;

    private VerificationError(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerificationError fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerificationError> knownValues() {
        EnumSet<VerificationError> knownValues = EnumSet.allOf(VerificationError.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VerificationError.class, VerificationError::toString);
    }
}

