/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sesv2.DefaultSesV2BaseClientBuilder;
import software.amazon.awssdk.services.sesv2.DefaultSesV2Client;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.SesV2ClientBuilder;
import software.amazon.awssdk.services.sesv2.SesV2ServiceClientConfiguration;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;

@SdkInternalApi
final class DefaultSesV2ClientBuilder
extends DefaultSesV2BaseClientBuilder<SesV2ClientBuilder, SesV2Client>
implements SesV2ClientBuilder {
    DefaultSesV2ClientBuilder() {
    }

    @Override
    public DefaultSesV2ClientBuilder endpointProvider(SesV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SesV2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSesV2ClientBuilder.validateClientOptions(clientConfiguration);
        SesV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSesV2Client client = new DefaultSesV2Client(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SesV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SesV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

