/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of objects that provide deliverability data for all the campaigns that used a specific domain to send email
 * during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard
 * for the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainDeliverabilityCampaignsResponse extends SesV2Response implements
        ToCopyableBuilder<ListDomainDeliverabilityCampaignsResponse.Builder, ListDomainDeliverabilityCampaignsResponse> {
    private static final SdkField<List<DomainDeliverabilityCampaign>> DOMAIN_DELIVERABILITY_CAMPAIGNS_FIELD = SdkField
            .<List<DomainDeliverabilityCampaign>> builder(MarshallingType.LIST)
            .memberName("DomainDeliverabilityCampaigns")
            .getter(getter(ListDomainDeliverabilityCampaignsResponse::domainDeliverabilityCampaigns))
            .setter(setter(Builder::domainDeliverabilityCampaigns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDeliverabilityCampaigns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainDeliverabilityCampaign> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainDeliverabilityCampaign::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDomainDeliverabilityCampaignsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_DELIVERABILITY_CAMPAIGNS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns;

    private final String nextToken;

    private ListDomainDeliverabilityCampaignsResponse(BuilderImpl builder) {
        super(builder);
        this.domainDeliverabilityCampaigns = builder.domainDeliverabilityCampaigns;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainDeliverabilityCampaigns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainDeliverabilityCampaigns() {
        return domainDeliverabilityCampaigns != null && !(domainDeliverabilityCampaigns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of responses, one for each campaign that used the domain to send email during the specified time range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainDeliverabilityCampaigns} method.
     * </p>
     * 
     * @return An array of responses, one for each campaign that used the domain to send email during the specified time
     *         range.
     */
    public final List<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns() {
        return domainDeliverabilityCampaigns;
    }

    /**
     * <p>
     * A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation.
     * This token indicates the position of the campaign in the list of campaigns.
     * </p>
     * 
     * @return A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code>
     *         operation. This token indicates the position of the campaign in the list of campaigns.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainDeliverabilityCampaigns() ? domainDeliverabilityCampaigns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainDeliverabilityCampaignsResponse)) {
            return false;
        }
        ListDomainDeliverabilityCampaignsResponse other = (ListDomainDeliverabilityCampaignsResponse) obj;
        return hasDomainDeliverabilityCampaigns() == other.hasDomainDeliverabilityCampaigns()
                && Objects.equals(domainDeliverabilityCampaigns(), other.domainDeliverabilityCampaigns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListDomainDeliverabilityCampaignsResponse")
                .add("DomainDeliverabilityCampaigns", hasDomainDeliverabilityCampaigns() ? domainDeliverabilityCampaigns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainDeliverabilityCampaigns":
            return Optional.ofNullable(clazz.cast(domainDeliverabilityCampaigns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainDeliverabilityCampaignsResponse, T> g) {
        return obj -> g.apply((ListDomainDeliverabilityCampaignsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDomainDeliverabilityCampaignsResponse> {
        /**
         * <p>
         * An array of responses, one for each campaign that used the domain to send email during the specified time
         * range.
         * </p>
         * 
         * @param domainDeliverabilityCampaigns
         *        An array of responses, one for each campaign that used the domain to send email during the specified
         *        time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDeliverabilityCampaigns(Collection<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns);

        /**
         * <p>
         * An array of responses, one for each campaign that used the domain to send email during the specified time
         * range.
         * </p>
         * 
         * @param domainDeliverabilityCampaigns
         *        An array of responses, one for each campaign that used the domain to send email during the specified
         *        time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDeliverabilityCampaigns(DomainDeliverabilityCampaign... domainDeliverabilityCampaigns);

        /**
         * <p>
         * An array of responses, one for each campaign that used the domain to send email during the specified time
         * range.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <DomainDeliverabilityCampaign>.Builder} avoiding the need to create one manually via {@link List
         * <DomainDeliverabilityCampaign>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainDeliverabilityCampaign>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #domainDeliverabilityCampaigns(List<DomainDeliverabilityCampaign>)}.
         * 
         * @param domainDeliverabilityCampaigns
         *        a consumer that will call methods on {@link List<DomainDeliverabilityCampaign>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainDeliverabilityCampaigns(List<DomainDeliverabilityCampaign>)
         */
        Builder domainDeliverabilityCampaigns(Consumer<DomainDeliverabilityCampaign.Builder>... domainDeliverabilityCampaigns);

        /**
         * <p>
         * A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation.
         * This token indicates the position of the campaign in the list of campaigns.
         * </p>
         * 
         * @param nextToken
         *        A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code>
         *        operation. This token indicates the position of the campaign in the list of campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainDeliverabilityCampaignsResponse model) {
            super(model);
            domainDeliverabilityCampaigns(model.domainDeliverabilityCampaigns);
            nextToken(model.nextToken);
        }

        public final List<DomainDeliverabilityCampaign.Builder> getDomainDeliverabilityCampaigns() {
            List<DomainDeliverabilityCampaign.Builder> result = DomainDeliverabilityCampaignListCopier
                    .copyToBuilder(this.domainDeliverabilityCampaigns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainDeliverabilityCampaigns(
                Collection<DomainDeliverabilityCampaign.BuilderImpl> domainDeliverabilityCampaigns) {
            this.domainDeliverabilityCampaigns = DomainDeliverabilityCampaignListCopier
                    .copyFromBuilder(domainDeliverabilityCampaigns);
        }

        @Override
        public final Builder domainDeliverabilityCampaigns(Collection<DomainDeliverabilityCampaign> domainDeliverabilityCampaigns) {
            this.domainDeliverabilityCampaigns = DomainDeliverabilityCampaignListCopier.copy(domainDeliverabilityCampaigns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainDeliverabilityCampaigns(DomainDeliverabilityCampaign... domainDeliverabilityCampaigns) {
            domainDeliverabilityCampaigns(Arrays.asList(domainDeliverabilityCampaigns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainDeliverabilityCampaigns(
                Consumer<DomainDeliverabilityCampaign.Builder>... domainDeliverabilityCampaigns) {
            domainDeliverabilityCampaigns(Stream.of(domainDeliverabilityCampaigns)
                    .map(c -> DomainDeliverabilityCampaign.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDomainDeliverabilityCampaignsResponse build() {
            return new ListDomainDeliverabilityCampaignsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
