/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Recipient-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES
 * receives on your behalf bounces.
 * </p>
 * <p>
 * For information about receiving email through Amazon SES, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecipientDsnFields implements SdkPojo, Serializable,
        ToCopyableBuilder<RecipientDsnFields.Builder, RecipientDsnFields> {
    private static final SdkField<String> FINAL_RECIPIENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FinalRecipient").getter(getter(RecipientDsnFields::finalRecipient))
            .setter(setter(Builder::finalRecipient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalRecipient").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(RecipientDsnFields::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> REMOTE_MTA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteMta").getter(getter(RecipientDsnFields::remoteMta)).setter(setter(Builder::remoteMta))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteMta").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RecipientDsnFields::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DIAGNOSTIC_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiagnosticCode").getter(getter(RecipientDsnFields::diagnosticCode))
            .setter(setter(Builder::diagnosticCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiagnosticCode").build()).build();

    private static final SdkField<Instant> LAST_ATTEMPT_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAttemptDate").getter(getter(RecipientDsnFields::lastAttemptDate))
            .setter(setter(Builder::lastAttemptDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAttemptDate").build()).build();

    private static final SdkField<List<ExtensionField>> EXTENSION_FIELDS_FIELD = SdkField
            .<List<ExtensionField>> builder(MarshallingType.LIST)
            .memberName("ExtensionFields")
            .getter(getter(RecipientDsnFields::extensionFields))
            .setter(setter(Builder::extensionFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExtensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExtensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FINAL_RECIPIENT_FIELD, ACTION_FIELD, REMOTE_MTA_FIELD, STATUS_FIELD,
                    DIAGNOSTIC_CODE_FIELD, LAST_ATTEMPT_DATE_FIELD, EXTENSION_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String finalRecipient;

    private final String action;

    private final String remoteMta;

    private final String status;

    private final String diagnosticCode;

    private final Instant lastAttemptDate;

    private final List<ExtensionField> extensionFields;

    private RecipientDsnFields(BuilderImpl builder) {
        this.finalRecipient = builder.finalRecipient;
        this.action = builder.action;
        this.remoteMta = builder.remoteMta;
        this.status = builder.status;
        this.diagnosticCode = builder.diagnosticCode;
        this.lastAttemptDate = builder.lastAttemptDate;
        this.extensionFields = builder.extensionFields;
    }

    /**
     * <p>
     * The email address that the message was ultimately delivered to. This corresponds to the
     * <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> is set to the
     * <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
     * <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the
     * original bounced message.
     * </p>
     * <note>
     * <p>
     * Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described in <a
     * href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
     * </p>
     * </note>
     * 
     * @return The email address that the message was ultimately delivered to. This corresponds to the
     *         <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> is set to the
     *         <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
     *         <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient of
     *         the original bounced message.</p> <note>
     *         <p>
     *         Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described in
     *         <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
     *         </p>
     */
    public final String finalRecipient() {
        return finalRecipient;
    }

    /**
     * <p>
     * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the message
     * to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DsnAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the
     *         message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC
     *         3464</a>.
     * @see DsnAction
     */
    public final DsnAction action() {
        return DsnAction.fromValue(action);
    }

    /**
     * <p>
     * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the message
     * to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DsnAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the
     *         message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC
     *         3464</a>.
     * @see DsnAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
     * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This parameter
     * typically applies only to propagating synchronous bounces.
     * </p>
     * 
     * @return The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
     *         href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This
     *         parameter typically applies only to propagating synchronous bounces.
     */
    public final String remoteMta() {
        return remoteMta;
    }

    /**
     * <p>
     * The status code that indicates what went wrong. This is required by <a
     * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
     * </p>
     * 
     * @return The status code that indicates what went wrong. This is required by <a
     *         href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * An extended explanation of what went wrong; this is usually an SMTP response. See <a
     * href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
     * </p>
     * 
     * @return An extended explanation of what went wrong; this is usually an SMTP response. See <a
     *         href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
     */
    public final String diagnosticCode() {
        return diagnosticCode;
    }

    /**
     * <p>
     * The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>
     * date-time format.
     * </p>
     * 
     * @return The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC
     *         822</a> date-time format.
     */
    public final Instant lastAttemptDate() {
        return lastAttemptDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtensionFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtensionFields() {
        return extensionFields != null && !(extensionFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional X-headers to include in the DSN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtensionFields} method.
     * </p>
     * 
     * @return Additional X-headers to include in the DSN.
     */
    public final List<ExtensionField> extensionFields() {
        return extensionFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(finalRecipient());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteMta());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(diagnosticCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasExtensionFields() ? extensionFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipientDsnFields)) {
            return false;
        }
        RecipientDsnFields other = (RecipientDsnFields) obj;
        return Objects.equals(finalRecipient(), other.finalRecipient())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(remoteMta(), other.remoteMta())
                && Objects.equals(status(), other.status()) && Objects.equals(diagnosticCode(), other.diagnosticCode())
                && Objects.equals(lastAttemptDate(), other.lastAttemptDate())
                && hasExtensionFields() == other.hasExtensionFields()
                && Objects.equals(extensionFields(), other.extensionFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecipientDsnFields").add("FinalRecipient", finalRecipient()).add("Action", actionAsString())
                .add("RemoteMta", remoteMta()).add("Status", status()).add("DiagnosticCode", diagnosticCode())
                .add("LastAttemptDate", lastAttemptDate())
                .add("ExtensionFields", hasExtensionFields() ? extensionFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FinalRecipient":
            return Optional.ofNullable(clazz.cast(finalRecipient()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "RemoteMta":
            return Optional.ofNullable(clazz.cast(remoteMta()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DiagnosticCode":
            return Optional.ofNullable(clazz.cast(diagnosticCode()));
        case "LastAttemptDate":
            return Optional.ofNullable(clazz.cast(lastAttemptDate()));
        case "ExtensionFields":
            return Optional.ofNullable(clazz.cast(extensionFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FinalRecipient", FINAL_RECIPIENT_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("RemoteMta", REMOTE_MTA_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DiagnosticCode", DIAGNOSTIC_CODE_FIELD);
        map.put("LastAttemptDate", LAST_ATTEMPT_DATE_FIELD);
        map.put("ExtensionFields", EXTENSION_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecipientDsnFields, T> g) {
        return obj -> g.apply((RecipientDsnFields) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecipientDsnFields> {
        /**
         * <p>
         * The email address that the message was ultimately delivered to. This corresponds to the
         * <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> is set to the
         * <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
         * <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the
         * original bounced message.
         * </p>
         * <note>
         * <p>
         * Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described in <a
         * href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
         * </p>
         * </note>
         * 
         * @param finalRecipient
         *        The email address that the message was ultimately delivered to. This corresponds to the
         *        <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> is set to the
         *        <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
         *        <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient
         *        of the original bounced message.</p> <note>
         *        <p>
         *        Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described
         *        in <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalRecipient(String finalRecipient);

        /**
         * <p>
         * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the
         * message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC
         * 3464</a>.
         * </p>
         * 
         * @param action
         *        The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver
         *        the message to the recipient address. This is required by <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * @see DsnAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DsnAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the
         * message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC
         * 3464</a>.
         * </p>
         * 
         * @param action
         *        The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver
         *        the message to the recipient address. This is required by <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * @see DsnAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DsnAction
         */
        Builder action(DsnAction action);

        /**
         * <p>
         * The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
         * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This
         * parameter typically applies only to propagating synchronous bounces.
         * </p>
         * 
         * @param remoteMta
         *        The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This
         *        parameter typically applies only to propagating synchronous bounces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteMta(String remoteMta);

        /**
         * <p>
         * The status code that indicates what went wrong. This is required by <a
         * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * </p>
         * 
         * @param status
         *        The status code that indicates what went wrong. This is required by <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * An extended explanation of what went wrong; this is usually an SMTP response. See <a
         * href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
         * </p>
         * 
         * @param diagnosticCode
         *        An extended explanation of what went wrong; this is usually an SMTP response. See <a
         *        href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diagnosticCode(String diagnosticCode);

        /**
         * <p>
         * The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>
         * date-time format.
         * </p>
         * 
         * @param lastAttemptDate
         *        The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC
         *        822</a> date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptDate(Instant lastAttemptDate);

        /**
         * <p>
         * Additional X-headers to include in the DSN.
         * </p>
         * 
         * @param extensionFields
         *        Additional X-headers to include in the DSN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionFields(Collection<ExtensionField> extensionFields);

        /**
         * <p>
         * Additional X-headers to include in the DSN.
         * </p>
         * 
         * @param extensionFields
         *        Additional X-headers to include in the DSN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionFields(ExtensionField... extensionFields);

        /**
         * <p>
         * Additional X-headers to include in the DSN.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ses.model.ExtensionField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ses.model.ExtensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ses.model.ExtensionField.Builder#build()} is called immediately and
         * its result is passed to {@link #extensionFields(List<ExtensionField>)}.
         * 
         * @param extensionFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ses.model.ExtensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extensionFields(java.util.Collection<ExtensionField>)
         */
        Builder extensionFields(Consumer<ExtensionField.Builder>... extensionFields);
    }

    static final class BuilderImpl implements Builder {
        private String finalRecipient;

        private String action;

        private String remoteMta;

        private String status;

        private String diagnosticCode;

        private Instant lastAttemptDate;

        private List<ExtensionField> extensionFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecipientDsnFields model) {
            finalRecipient(model.finalRecipient);
            action(model.action);
            remoteMta(model.remoteMta);
            status(model.status);
            diagnosticCode(model.diagnosticCode);
            lastAttemptDate(model.lastAttemptDate);
            extensionFields(model.extensionFields);
        }

        public final String getFinalRecipient() {
            return finalRecipient;
        }

        public final void setFinalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
        }

        @Override
        public final Builder finalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DsnAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getRemoteMta() {
            return remoteMta;
        }

        public final void setRemoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
        }

        @Override
        public final Builder remoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getDiagnosticCode() {
            return diagnosticCode;
        }

        public final void setDiagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
        }

        @Override
        public final Builder diagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
            return this;
        }

        public final Instant getLastAttemptDate() {
            return lastAttemptDate;
        }

        public final void setLastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
        }

        @Override
        public final Builder lastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
            return this;
        }

        public final List<ExtensionField.Builder> getExtensionFields() {
            List<ExtensionField.Builder> result = ExtensionFieldListCopier.copyToBuilder(this.extensionFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtensionFields(Collection<ExtensionField.BuilderImpl> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copyFromBuilder(extensionFields);
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField... extensionFields) {
            extensionFields(Arrays.asList(extensionFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(Consumer<ExtensionField.Builder>... extensionFields) {
            extensionFields(Stream.of(extensionFields).map(c -> ExtensionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecipientDsnFields build() {
            return new RecipientDsnFields(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
