/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.AddHeaderAction;
import software.amazon.awssdk.services.ses.model.BounceAction;
import software.amazon.awssdk.services.ses.model.LambdaAction;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.S3Action;
import software.amazon.awssdk.services.ses.model.SNSAction;
import software.amazon.awssdk.services.ses.model.StopAction;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.WorkmailAction;

public class UpdateReceiptRuleRequestMarshaller
implements Marshaller<Request<UpdateReceiptRuleRequest>, UpdateReceiptRuleRequest> {
    public Request<UpdateReceiptRuleRequest> marshall(UpdateReceiptRuleRequest updateReceiptRuleRequest) {
        ReceiptRule rule;
        if (updateReceiptRuleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateReceiptRuleRequest, "SesClient");
        request.addParameter("Action", "UpdateReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringConversion.fromString((String)updateReceiptRuleRequest.ruleSetName()));
        }
        if ((rule = updateReceiptRuleRequest.rule()) != null) {
            if (rule.name() != null) {
                request.addParameter("Rule.Name", StringConversion.fromString((String)rule.name()));
            }
            if (rule.enabled() != null) {
                request.addParameter("Rule.Enabled", StringConversion.fromBoolean((Boolean)rule.enabled()));
            }
            if (rule.tlsPolicyAsString() != null) {
                request.addParameter("Rule.TlsPolicy", StringConversion.fromString((String)rule.tlsPolicyAsString()));
            }
            if (rule.recipients().isEmpty() && !(rule.recipients() instanceof SdkAutoConstructList)) {
                request.addParameter("Rule.Recipients", "");
            } else if (!rule.recipients().isEmpty() && !(rule.recipients() instanceof SdkAutoConstructList)) {
                List<String> recipientsList = rule.recipients();
                int recipientsListIndex = 1;
                for (String recipientsListValue : recipientsList) {
                    if (recipientsListValue != null) {
                        request.addParameter("Rule.Recipients.member." + recipientsListIndex, StringConversion.fromString((String)recipientsListValue));
                    }
                    ++recipientsListIndex;
                }
            }
            if (rule.actions().isEmpty() && !(rule.actions() instanceof SdkAutoConstructList)) {
                request.addParameter("Rule.Actions", "");
            } else if (!rule.actions().isEmpty() && !(rule.actions() instanceof SdkAutoConstructList)) {
                List<ReceiptAction> actionsList = rule.actions();
                int actionsListIndex = 1;
                for (ReceiptAction actionsListValue : actionsList) {
                    SNSAction snsAction;
                    AddHeaderAction addHeaderAction;
                    StopAction stopAction;
                    LambdaAction lambdaAction;
                    WorkmailAction workmailAction;
                    BounceAction bounceAction;
                    S3Action s3Action = actionsListValue.s3Action();
                    if (s3Action != null) {
                        if (s3Action.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.TopicArn", StringConversion.fromString((String)s3Action.topicArn()));
                        }
                        if (s3Action.bucketName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.BucketName", StringConversion.fromString((String)s3Action.bucketName()));
                        }
                        if (s3Action.objectKeyPrefix() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.ObjectKeyPrefix", StringConversion.fromString((String)s3Action.objectKeyPrefix()));
                        }
                        if (s3Action.kmsKeyArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.KmsKeyArn", StringConversion.fromString((String)s3Action.kmsKeyArn()));
                        }
                    }
                    if ((bounceAction = actionsListValue.bounceAction()) != null) {
                        if (bounceAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.TopicArn", StringConversion.fromString((String)bounceAction.topicArn()));
                        }
                        if (bounceAction.smtpReplyCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.SmtpReplyCode", StringConversion.fromString((String)bounceAction.smtpReplyCode()));
                        }
                        if (bounceAction.statusCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.StatusCode", StringConversion.fromString((String)bounceAction.statusCode()));
                        }
                        if (bounceAction.message() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Message", StringConversion.fromString((String)bounceAction.message()));
                        }
                        if (bounceAction.sender() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Sender", StringConversion.fromString((String)bounceAction.sender()));
                        }
                    }
                    if ((workmailAction = actionsListValue.workmailAction()) != null) {
                        if (workmailAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.TopicArn", StringConversion.fromString((String)workmailAction.topicArn()));
                        }
                        if (workmailAction.organizationArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.OrganizationArn", StringConversion.fromString((String)workmailAction.organizationArn()));
                        }
                    }
                    if ((lambdaAction = actionsListValue.lambdaAction()) != null) {
                        if (lambdaAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.TopicArn", StringConversion.fromString((String)lambdaAction.topicArn()));
                        }
                        if (lambdaAction.functionArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.FunctionArn", StringConversion.fromString((String)lambdaAction.functionArn()));
                        }
                        if (lambdaAction.invocationTypeAsString() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.InvocationType", StringConversion.fromString((String)lambdaAction.invocationTypeAsString()));
                        }
                    }
                    if ((stopAction = actionsListValue.stopAction()) != null) {
                        if (stopAction.scopeAsString() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.Scope", StringConversion.fromString((String)stopAction.scopeAsString()));
                        }
                        if (stopAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.TopicArn", StringConversion.fromString((String)stopAction.topicArn()));
                        }
                    }
                    if ((addHeaderAction = actionsListValue.addHeaderAction()) != null) {
                        if (addHeaderAction.headerName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderName", StringConversion.fromString((String)addHeaderAction.headerName()));
                        }
                        if (addHeaderAction.headerValue() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderValue", StringConversion.fromString((String)addHeaderAction.headerValue()));
                        }
                    }
                    if ((snsAction = actionsListValue.snsAction()) != null) {
                        if (snsAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.TopicArn", StringConversion.fromString((String)snsAction.topicArn()));
                        }
                        if (snsAction.encodingAsString() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.Encoding", StringConversion.fromString((String)snsAction.encodingAsString()));
                        }
                    }
                    ++actionsListIndex;
                }
            }
            if (rule.scanEnabled() != null) {
                request.addParameter("Rule.ScanEnabled", StringConversion.fromBoolean((Boolean)rule.scanEnabled()));
            }
        }
        return request;
    }
}

