/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest;

public class SendTemplatedEmailRequestMarshaller
implements Marshaller<Request<SendTemplatedEmailRequest>, SendTemplatedEmailRequest> {
    public Request<SendTemplatedEmailRequest> marshall(SendTemplatedEmailRequest sendTemplatedEmailRequest) {
        Destination destination;
        if (sendTemplatedEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendTemplatedEmailRequest, "SesClient");
        request.addParameter("Action", "SendTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString((String)sendTemplatedEmailRequest.source()));
        }
        if ((destination = sendTemplatedEmailRequest.destination()) != null) {
            if (destination.toAddresses().isEmpty() && !(destination.toAddresses() instanceof SdkAutoConstructList)) {
                request.addParameter("Destination.ToAddresses", "");
            } else if (!destination.toAddresses().isEmpty() && !(destination.toAddresses() instanceof SdkAutoConstructList)) {
                List<String> toAddressesList = destination.toAddresses();
                int toAddressesListIndex = 1;
                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringConversion.fromString((String)toAddressesListValue));
                    }
                    ++toAddressesListIndex;
                }
            }
            if (destination.ccAddresses().isEmpty() && !(destination.ccAddresses() instanceof SdkAutoConstructList)) {
                request.addParameter("Destination.CcAddresses", "");
            } else if (!destination.ccAddresses().isEmpty() && !(destination.ccAddresses() instanceof SdkAutoConstructList)) {
                List<String> ccAddressesList = destination.ccAddresses();
                int ccAddressesListIndex = 1;
                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringConversion.fromString((String)ccAddressesListValue));
                    }
                    ++ccAddressesListIndex;
                }
            }
            if (destination.bccAddresses().isEmpty() && !(destination.bccAddresses() instanceof SdkAutoConstructList)) {
                request.addParameter("Destination.BccAddresses", "");
            } else if (!destination.bccAddresses().isEmpty() && !(destination.bccAddresses() instanceof SdkAutoConstructList)) {
                List<String> bccAddressesList = destination.bccAddresses();
                int bccAddressesListIndex = 1;
                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringConversion.fromString((String)bccAddressesListValue));
                    }
                    ++bccAddressesListIndex;
                }
            }
        }
        if (sendTemplatedEmailRequest.replyToAddresses().isEmpty() && !(sendTemplatedEmailRequest.replyToAddresses() instanceof SdkAutoConstructList)) {
            request.addParameter("ReplyToAddresses", "");
        } else if (!sendTemplatedEmailRequest.replyToAddresses().isEmpty() && !(sendTemplatedEmailRequest.replyToAddresses() instanceof SdkAutoConstructList)) {
            List<String> replyToAddressesList = sendTemplatedEmailRequest.replyToAddresses();
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringConversion.fromString((String)replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringConversion.fromString((String)sendTemplatedEmailRequest.returnPath()));
        }
        if (sendTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString((String)sendTemplatedEmailRequest.sourceArn()));
        }
        if (sendTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString((String)sendTemplatedEmailRequest.returnPathArn()));
        }
        if (sendTemplatedEmailRequest.tags().isEmpty() && !(sendTemplatedEmailRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!sendTemplatedEmailRequest.tags().isEmpty() && !(sendTemplatedEmailRequest.tags() instanceof SdkAutoConstructList)) {
            List<MessageTag> tagsList = sendTemplatedEmailRequest.tags();
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringConversion.fromString((String)tagsListValue.name()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (sendTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString((String)sendTemplatedEmailRequest.configurationSetName()));
        }
        if (sendTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringConversion.fromString((String)sendTemplatedEmailRequest.template()));
        }
        if (sendTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringConversion.fromString((String)sendTemplatedEmailRequest.templateArn()));
        }
        if (sendTemplatedEmailRequest.templateData() != null) {
            request.addParameter("TemplateData", StringConversion.fromString((String)sendTemplatedEmailRequest.templateData()));
        }
        return request;
    }
}

