/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;

public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        Message message;
        Destination destination;
        if (sendEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendEmailRequest, "SesClient");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString((String)sendEmailRequest.source()));
        }
        if ((destination = sendEmailRequest.destination()) != null) {
            if (destination.toAddresses().isEmpty() && !(destination.toAddresses() instanceof SdkAutoConstructList)) {
                request.addParameter("Destination.ToAddresses", "");
            } else if (!destination.toAddresses().isEmpty() && !(destination.toAddresses() instanceof SdkAutoConstructList)) {
                List<String> toAddressesList = destination.toAddresses();
                int toAddressesListIndex = 1;
                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringConversion.fromString((String)toAddressesListValue));
                    }
                    ++toAddressesListIndex;
                }
            }
            if (destination.ccAddresses().isEmpty() && !(destination.ccAddresses() instanceof SdkAutoConstructList)) {
                request.addParameter("Destination.CcAddresses", "");
            } else if (!destination.ccAddresses().isEmpty() && !(destination.ccAddresses() instanceof SdkAutoConstructList)) {
                List<String> ccAddressesList = destination.ccAddresses();
                int ccAddressesListIndex = 1;
                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringConversion.fromString((String)ccAddressesListValue));
                    }
                    ++ccAddressesListIndex;
                }
            }
            if (destination.bccAddresses().isEmpty() && !(destination.bccAddresses() instanceof SdkAutoConstructList)) {
                request.addParameter("Destination.BccAddresses", "");
            } else if (!destination.bccAddresses().isEmpty() && !(destination.bccAddresses() instanceof SdkAutoConstructList)) {
                List<String> bccAddressesList = destination.bccAddresses();
                int bccAddressesListIndex = 1;
                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringConversion.fromString((String)bccAddressesListValue));
                    }
                    ++bccAddressesListIndex;
                }
            }
        }
        if ((message = sendEmailRequest.message()) != null) {
            Body body;
            Content subject = message.subject();
            if (subject != null) {
                if (subject.data() != null) {
                    request.addParameter("Message.Subject.Data", StringConversion.fromString((String)subject.data()));
                }
                if (subject.charset() != null) {
                    request.addParameter("Message.Subject.Charset", StringConversion.fromString((String)subject.charset()));
                }
            }
            if ((body = message.body()) != null) {
                Content html;
                Content text = body.text();
                if (text != null) {
                    if (text.data() != null) {
                        request.addParameter("Message.Body.Text.Data", StringConversion.fromString((String)text.data()));
                    }
                    if (text.charset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringConversion.fromString((String)text.charset()));
                    }
                }
                if ((html = body.html()) != null) {
                    if (html.data() != null) {
                        request.addParameter("Message.Body.Html.Data", StringConversion.fromString((String)html.data()));
                    }
                    if (html.charset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringConversion.fromString((String)html.charset()));
                    }
                }
            }
        }
        if (sendEmailRequest.replyToAddresses().isEmpty() && !(sendEmailRequest.replyToAddresses() instanceof SdkAutoConstructList)) {
            request.addParameter("ReplyToAddresses", "");
        } else if (!sendEmailRequest.replyToAddresses().isEmpty() && !(sendEmailRequest.replyToAddresses() instanceof SdkAutoConstructList)) {
            List<String> replyToAddressesList = sendEmailRequest.replyToAddresses();
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringConversion.fromString((String)replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringConversion.fromString((String)sendEmailRequest.returnPath()));
        }
        if (sendEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString((String)sendEmailRequest.sourceArn()));
        }
        if (sendEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString((String)sendEmailRequest.returnPathArn()));
        }
        if (sendEmailRequest.tags().isEmpty() && !(sendEmailRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!sendEmailRequest.tags().isEmpty() && !(sendEmailRequest.tags() instanceof SdkAutoConstructList)) {
            List<MessageTag> tagsList = sendEmailRequest.tags();
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringConversion.fromString((String)tagsListValue.name()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (sendEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString((String)sendEmailRequest.configurationSetName()));
        }
        return request;
    }
}

