/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ReputationOptions;

public class ReputationOptionsUnmarshaller
implements Unmarshaller<ReputationOptions, StaxUnmarshallerContext> {
    private static final ReputationOptionsUnmarshaller INSTANCE = new ReputationOptionsUnmarshaller();

    public ReputationOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReputationOptions.Builder reputationOptions = ReputationOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SendingEnabled", targetDepth)) {
                    reputationOptions.sendingEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReputationMetricsEnabled", targetDepth)) {
                    reputationOptions.reputationMetricsEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LastFreshStart", targetDepth)) continue;
                reputationOptions.lastFreshStart(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReputationOptions)reputationOptions.build();
    }

    public static ReputationOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

