/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest;

public class ReorderReceiptRuleSetRequestMarshaller
implements Marshaller<Request<ReorderReceiptRuleSetRequest>, ReorderReceiptRuleSetRequest> {
    public Request<ReorderReceiptRuleSetRequest> marshall(ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest) {
        if (reorderReceiptRuleSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)reorderReceiptRuleSetRequest, "SesClient");
        request.addParameter("Action", "ReorderReceiptRuleSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (reorderReceiptRuleSetRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringConversion.fromString((String)reorderReceiptRuleSetRequest.ruleSetName()));
        }
        if (reorderReceiptRuleSetRequest.ruleNames().isEmpty() && !(reorderReceiptRuleSetRequest.ruleNames() instanceof SdkAutoConstructList)) {
            request.addParameter("RuleNames", "");
        } else if (!reorderReceiptRuleSetRequest.ruleNames().isEmpty() && !(reorderReceiptRuleSetRequest.ruleNames() instanceof SdkAutoConstructList)) {
            List<String> ruleNamesList = reorderReceiptRuleSetRequest.ruleNames();
            int ruleNamesListIndex = 1;
            for (String ruleNamesListValue : ruleNamesList) {
                if (ruleNamesListValue != null) {
                    request.addParameter("RuleNames.member." + ruleNamesListIndex, StringConversion.fromString((String)ruleNamesListValue));
                }
                ++ruleNamesListIndex;
            }
        }
        return request;
    }
}

