/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.MessageDsn;
import software.amazon.awssdk.services.ses.transform.ExtensionFieldUnmarshaller;

public class MessageDsnUnmarshaller
implements Unmarshaller<MessageDsn, StaxUnmarshallerContext> {
    private static final MessageDsnUnmarshaller INSTANCE = new MessageDsnUnmarshaller();

    public MessageDsn unmarshall(StaxUnmarshallerContext context) throws Exception {
        MessageDsn.Builder messageDsn;
        block7: {
            messageDsn = MessageDsn.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ExtensionField> extensionFields = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    messageDsn.extensionFields(extensionFields);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ReportingMta", targetDepth)) {
                        messageDsn.reportingMta(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ArrivalDate", targetDepth)) {
                        messageDsn.arrivalDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ExtensionFields", targetDepth)) {
                        extensionFields = new ArrayList<ExtensionField>();
                        continue;
                    }
                    if (!context.testExpression("ExtensionFields/member", targetDepth)) continue;
                    extensionFields.add(ExtensionFieldUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            messageDsn.extensionFields(extensionFields);
        }
        return (MessageDsn)messageDsn.build();
    }

    public static MessageDsnUnmarshaller getInstance() {
        return INSTANCE;
    }
}

