/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest;

public class DescribeConfigurationSetRequestMarshaller
implements Marshaller<Request<DescribeConfigurationSetRequest>, DescribeConfigurationSetRequest> {
    public Request<DescribeConfigurationSetRequest> marshall(DescribeConfigurationSetRequest describeConfigurationSetRequest) {
        if (describeConfigurationSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeConfigurationSetRequest, "SesClient");
        request.addParameter("Action", "DescribeConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationSetRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString((String)describeConfigurationSetRequest.configurationSetName()));
        }
        if (describeConfigurationSetRequest.configurationSetAttributeNamesAsStrings().isEmpty() && !(describeConfigurationSetRequest.configurationSetAttributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("ConfigurationSetAttributeNames", "");
        } else if (!describeConfigurationSetRequest.configurationSetAttributeNamesAsStrings().isEmpty() && !(describeConfigurationSetRequest.configurationSetAttributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> configurationSetAttributeNamesList = describeConfigurationSetRequest.configurationSetAttributeNamesAsStrings();
            int configurationSetAttributeNamesListIndex = 1;
            for (String configurationSetAttributeNamesListValue : configurationSetAttributeNamesList) {
                if (configurationSetAttributeNamesListValue != null) {
                    request.addParameter("ConfigurationSetAttributeNames.member." + configurationSetAttributeNamesListIndex, StringConversion.fromString((String)configurationSetAttributeNamesListValue));
                }
                ++configurationSetAttributeNamesListIndex;
            }
        }
        return request;
    }
}

