/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest;

public class DeleteReceiptRuleRequestMarshaller
implements Marshaller<Request<DeleteReceiptRuleRequest>, DeleteReceiptRuleRequest> {
    public Request<DeleteReceiptRuleRequest> marshall(DeleteReceiptRuleRequest deleteReceiptRuleRequest) {
        if (deleteReceiptRuleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteReceiptRuleRequest, "SesClient");
        request.addParameter("Action", "DeleteReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringConversion.fromString((String)deleteReceiptRuleRequest.ruleSetName()));
        }
        if (deleteReceiptRuleRequest.ruleName() != null) {
            request.addParameter("RuleName", StringConversion.fromString((String)deleteReceiptRuleRequest.ruleName()));
        }
        return request;
    }
}

