/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.ExtensionFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageDsn
implements ToCopyableBuilder<Builder, MessageDsn> {
    private final String reportingMta;
    private final Instant arrivalDate;
    private final List<ExtensionField> extensionFields;

    private MessageDsn(BuilderImpl builder) {
        this.reportingMta = builder.reportingMta;
        this.arrivalDate = builder.arrivalDate;
        this.extensionFields = builder.extensionFields;
    }

    public String reportingMta() {
        return this.reportingMta;
    }

    public Instant arrivalDate() {
        return this.arrivalDate;
    }

    public List<ExtensionField> extensionFields() {
        return this.extensionFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportingMta());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrivalDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageDsn)) {
            return false;
        }
        MessageDsn other = (MessageDsn)obj;
        return Objects.equals(this.reportingMta(), other.reportingMta()) && Objects.equals(this.arrivalDate(), other.arrivalDate()) && Objects.equals(this.extensionFields(), other.extensionFields());
    }

    public String toString() {
        return ToString.builder((String)"MessageDsn").add("ReportingMta", (Object)this.reportingMta()).add("ArrivalDate", (Object)this.arrivalDate()).add("ExtensionFields", this.extensionFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportingMta": {
                return Optional.ofNullable(clazz.cast(this.reportingMta()));
            }
            case "ArrivalDate": {
                return Optional.ofNullable(clazz.cast(this.arrivalDate()));
            }
            case "ExtensionFields": {
                return Optional.ofNullable(clazz.cast(this.extensionFields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String reportingMta;
        private Instant arrivalDate;
        private List<ExtensionField> extensionFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageDsn model) {
            this.reportingMta(model.reportingMta);
            this.arrivalDate(model.arrivalDate);
            this.extensionFields(model.extensionFields);
        }

        public final String getReportingMta() {
            return this.reportingMta;
        }

        @Override
        public final Builder reportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
            return this;
        }

        public final void setReportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
        }

        public final Instant getArrivalDate() {
            return this.arrivalDate;
        }

        @Override
        public final Builder arrivalDate(Instant arrivalDate) {
            this.arrivalDate = arrivalDate;
            return this;
        }

        public final void setArrivalDate(Instant arrivalDate) {
            this.arrivalDate = arrivalDate;
        }

        public final Collection<ExtensionField.Builder> getExtensionFields() {
            return this.extensionFields != null ? (Collection)this.extensionFields.stream().map(ExtensionField::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField ... extensionFields) {
            this.extensionFields(Arrays.asList(extensionFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(Consumer<ExtensionField.Builder> ... extensionFields) {
            this.extensionFields(Stream.of(extensionFields).map(c -> (ExtensionField)((ExtensionField.Builder)ExtensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExtensionFields(Collection<ExtensionField.BuilderImpl> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copyFromBuilder(extensionFields);
        }

        public MessageDsn build() {
            return new MessageDsn(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageDsn> {
        public Builder reportingMta(String var1);

        public Builder arrivalDate(Instant var1);

        public Builder extensionFields(Collection<ExtensionField> var1);

        public Builder extensionFields(ExtensionField ... var1);

        public Builder extensionFields(Consumer<ExtensionField.Builder> ... var1);
    }
}

