/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SendBulkTemplatedEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendBulkTemplatedEmailRequestMarshaller implements
        Marshaller<Request<SendBulkTemplatedEmailRequest>, SendBulkTemplatedEmailRequest> {

    public Request<SendBulkTemplatedEmailRequest> marshall(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) {

        if (sendBulkTemplatedEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SendBulkTemplatedEmailRequest> request = new DefaultRequest<SendBulkTemplatedEmailRequest>(
                sendBulkTemplatedEmailRequest, "SesClient");
        request.addParameter("Action", "SendBulkTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendBulkTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString(sendBulkTemplatedEmailRequest.source()));
        }

        if (sendBulkTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString(sendBulkTemplatedEmailRequest.sourceArn()));
        }

        if (sendBulkTemplatedEmailRequest.replyToAddresses().isEmpty()
                && !(sendBulkTemplatedEmailRequest.replyToAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ReplyToAddresses", "");
        } else if (!sendBulkTemplatedEmailRequest.replyToAddresses().isEmpty()
                && !(sendBulkTemplatedEmailRequest.replyToAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> replyToAddressesList = sendBulkTemplatedEmailRequest.replyToAddresses();
            int replyToAddressesListIndex = 1;

            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex,
                            StringConversion.fromString(replyToAddressesListValue));
                }
                replyToAddressesListIndex++;
            }
        }

        if (sendBulkTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringConversion.fromString(sendBulkTemplatedEmailRequest.returnPath()));
        }

        if (sendBulkTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString(sendBulkTemplatedEmailRequest.returnPathArn()));
        }

        if (sendBulkTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringConversion.fromString(sendBulkTemplatedEmailRequest.configurationSetName()));
        }

        if (sendBulkTemplatedEmailRequest.defaultTags().isEmpty()
                && !(sendBulkTemplatedEmailRequest.defaultTags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("DefaultTags", "");
        } else if (!sendBulkTemplatedEmailRequest.defaultTags().isEmpty()
                && !(sendBulkTemplatedEmailRequest.defaultTags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<MessageTag> defaultTagsList = sendBulkTemplatedEmailRequest.defaultTags();
            int defaultTagsListIndex = 1;

            for (MessageTag defaultTagsListValue : defaultTagsList) {

                if (defaultTagsListValue.name() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Name",
                            StringConversion.fromString(defaultTagsListValue.name()));
                }

                if (defaultTagsListValue.value() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Value",
                            StringConversion.fromString(defaultTagsListValue.value()));
                }
                defaultTagsListIndex++;
            }
        }

        if (sendBulkTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringConversion.fromString(sendBulkTemplatedEmailRequest.template()));
        }

        if (sendBulkTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringConversion.fromString(sendBulkTemplatedEmailRequest.templateArn()));
        }

        if (sendBulkTemplatedEmailRequest.defaultTemplateData() != null) {
            request.addParameter("DefaultTemplateData",
                    StringConversion.fromString(sendBulkTemplatedEmailRequest.defaultTemplateData()));
        }

        if (sendBulkTemplatedEmailRequest.destinations().isEmpty()
                && !(sendBulkTemplatedEmailRequest.destinations() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Destinations", "");
        } else if (!sendBulkTemplatedEmailRequest.destinations().isEmpty()
                && !(sendBulkTemplatedEmailRequest.destinations() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<BulkEmailDestination> destinationsList = sendBulkTemplatedEmailRequest.destinations();
            int destinationsListIndex = 1;

            for (BulkEmailDestination destinationsListValue : destinationsList) {

                Destination destination = destinationsListValue.destination();
                if (destination != null) {

                    if (destination.toAddresses().isEmpty()
                            && !(destination.toAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses", "");
                    } else if (!destination.toAddresses().isEmpty()
                            && !(destination.toAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        java.util.List<String> toAddressesList = destination.toAddresses();
                        int toAddressesListIndex = 1;

                        for (String toAddressesListValue : toAddressesList) {
                            if (toAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex
                                        + ".Destination.ToAddresses.member." + toAddressesListIndex,
                                        StringConversion.fromString(toAddressesListValue));
                            }
                            toAddressesListIndex++;
                        }
                    }

                    if (destination.ccAddresses().isEmpty()
                            && !(destination.ccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses", "");
                    } else if (!destination.ccAddresses().isEmpty()
                            && !(destination.ccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        java.util.List<String> ccAddressesList = destination.ccAddresses();
                        int ccAddressesListIndex = 1;

                        for (String ccAddressesListValue : ccAddressesList) {
                            if (ccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex
                                        + ".Destination.CcAddresses.member." + ccAddressesListIndex,
                                        StringConversion.fromString(ccAddressesListValue));
                            }
                            ccAddressesListIndex++;
                        }
                    }

                    if (destination.bccAddresses().isEmpty()
                            && !(destination.bccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.BccAddresses", "");
                    } else if (!destination.bccAddresses().isEmpty()
                            && !(destination.bccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        java.util.List<String> bccAddressesList = destination.bccAddresses();
                        int bccAddressesListIndex = 1;

                        for (String bccAddressesListValue : bccAddressesList) {
                            if (bccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex
                                        + ".Destination.BccAddresses.member." + bccAddressesListIndex,
                                        StringConversion.fromString(bccAddressesListValue));
                            }
                            bccAddressesListIndex++;
                        }
                    }
                }

                if (destinationsListValue.replacementTags().isEmpty()
                        && !(destinationsListValue.replacementTags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags", "");
                } else if (!destinationsListValue.replacementTags().isEmpty()
                        && !(destinationsListValue.replacementTags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    java.util.List<MessageTag> replacementTagsList = destinationsListValue.replacementTags();
                    int replacementTagsListIndex = 1;

                    for (MessageTag replacementTagsListValue : replacementTagsList) {

                        if (replacementTagsListValue.name() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member."
                                    + replacementTagsListIndex + ".Name",
                                    StringConversion.fromString(replacementTagsListValue.name()));
                        }

                        if (replacementTagsListValue.value() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member."
                                    + replacementTagsListIndex + ".Value",
                                    StringConversion.fromString(replacementTagsListValue.value()));
                        }
                        replacementTagsListIndex++;
                    }
                }

                if (destinationsListValue.replacementTemplateData() != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTemplateData",
                            StringConversion.fromString(destinationsListValue.replacementTemplateData()));
                }
                destinationsListIndex++;
            }
        }

        return request;
    }

}
