/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SendBounceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendBounceRequestMarshaller implements Marshaller<Request<SendBounceRequest>, SendBounceRequest> {

    public Request<SendBounceRequest> marshall(SendBounceRequest sendBounceRequest) {

        if (sendBounceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SendBounceRequest> request = new DefaultRequest<SendBounceRequest>(sendBounceRequest, "SesClient");
        request.addParameter("Action", "SendBounce");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendBounceRequest.originalMessageId() != null) {
            request.addParameter("OriginalMessageId", StringConversion.fromString(sendBounceRequest.originalMessageId()));
        }

        if (sendBounceRequest.bounceSender() != null) {
            request.addParameter("BounceSender", StringConversion.fromString(sendBounceRequest.bounceSender()));
        }

        if (sendBounceRequest.explanation() != null) {
            request.addParameter("Explanation", StringConversion.fromString(sendBounceRequest.explanation()));
        }

        MessageDsn messageDsn = sendBounceRequest.messageDsn();
        if (messageDsn != null) {

            if (messageDsn.reportingMta() != null) {
                request.addParameter("MessageDsn.ReportingMta", StringConversion.fromString(messageDsn.reportingMta()));
            }

            if (messageDsn.arrivalDate() != null) {
                request.addParameter("MessageDsn.ArrivalDate", StringConversion.fromInstant(messageDsn.arrivalDate()));
            }

            if (messageDsn.extensionFields().isEmpty()
                    && !(messageDsn.extensionFields() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("MessageDsn.ExtensionFields", "");
            } else if (!messageDsn.extensionFields().isEmpty()
                    && !(messageDsn.extensionFields() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<ExtensionField> extensionFieldsList = messageDsn.extensionFields();
                int extensionFieldsListIndex = 1;

                for (ExtensionField extensionFieldsListValue : extensionFieldsList) {

                    if (extensionFieldsListValue.name() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Name",
                                StringConversion.fromString(extensionFieldsListValue.name()));
                    }

                    if (extensionFieldsListValue.value() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Value",
                                StringConversion.fromString(extensionFieldsListValue.value()));
                    }
                    extensionFieldsListIndex++;
                }
            }
        }

        if (sendBounceRequest.bouncedRecipientInfoList().isEmpty()
                && !(sendBounceRequest.bouncedRecipientInfoList() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("BouncedRecipientInfoList", "");
        } else if (!sendBounceRequest.bouncedRecipientInfoList().isEmpty()
                && !(sendBounceRequest.bouncedRecipientInfoList() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<BouncedRecipientInfo> bouncedRecipientInfoListList = sendBounceRequest.bouncedRecipientInfoList();
            int bouncedRecipientInfoListListIndex = 1;

            for (BouncedRecipientInfo bouncedRecipientInfoListListValue : bouncedRecipientInfoListList) {

                if (bouncedRecipientInfoListListValue.recipient() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".Recipient",
                            StringConversion.fromString(bouncedRecipientInfoListListValue.recipient()));
                }

                if (bouncedRecipientInfoListListValue.recipientArn() != null) {
                    request.addParameter(
                            "BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientArn",
                            StringConversion.fromString(bouncedRecipientInfoListListValue.recipientArn()));
                }

                if (bouncedRecipientInfoListListValue.bounceTypeAsString() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".BounceType",
                            StringConversion.fromString(bouncedRecipientInfoListListValue.bounceTypeAsString()));
                }

                RecipientDsnFields recipientDsnFields = bouncedRecipientInfoListListValue.recipientDsnFields();
                if (recipientDsnFields != null) {

                    if (recipientDsnFields.finalRecipient() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientDsnFields.FinalRecipient",
                                StringConversion.fromString(recipientDsnFields.finalRecipient()));
                    }

                    if (recipientDsnFields.actionAsString() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientDsnFields.Action", StringConversion.fromString(recipientDsnFields.actionAsString()));
                    }

                    if (recipientDsnFields.remoteMta() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientDsnFields.RemoteMta", StringConversion.fromString(recipientDsnFields.remoteMta()));
                    }

                    if (recipientDsnFields.status() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientDsnFields.Status", StringConversion.fromString(recipientDsnFields.status()));
                    }

                    if (recipientDsnFields.diagnosticCode() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientDsnFields.DiagnosticCode",
                                StringConversion.fromString(recipientDsnFields.diagnosticCode()));
                    }

                    if (recipientDsnFields.lastAttemptDate() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientDsnFields.LastAttemptDate",
                                StringConversion.fromInstant(recipientDsnFields.lastAttemptDate()));
                    }

                    if (recipientDsnFields.extensionFields().isEmpty()
                            && !(recipientDsnFields.extensionFields() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                + ".RecipientDsnFields.ExtensionFields", "");
                    } else if (!recipientDsnFields.extensionFields().isEmpty()
                            && !(recipientDsnFields.extensionFields() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        java.util.List<ExtensionField> extensionFieldsList = recipientDsnFields.extensionFields();
                        int extensionFieldsListIndex = 1;

                        for (ExtensionField extensionFieldsListValue : extensionFieldsList) {

                            if (extensionFieldsListValue.name() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                        + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Name",
                                        StringConversion.fromString(extensionFieldsListValue.name()));
                            }

                            if (extensionFieldsListValue.value() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex
                                        + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Value",
                                        StringConversion.fromString(extensionFieldsListValue.value()));
                            }
                            extensionFieldsListIndex++;
                        }
                    }
                }
                bouncedRecipientInfoListListIndex++;
            }
        }

        if (sendBounceRequest.bounceSenderArn() != null) {
            request.addParameter("BounceSenderArn", StringConversion.fromString(sendBounceRequest.bounceSenderArn()));
        }

        return request;
    }

}
