/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to begin email address verification with Amazon SES. For information about email address
 * verification, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyEmailAddressRequest extends SesRequest implements
        ToCopyableBuilder<VerifyEmailAddressRequest.Builder, VerifyEmailAddressRequest> {
    private final String emailAddress;

    private VerifyEmailAddressRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddress = builder.emailAddress;
    }

    /**
     * <p>
     * The email address to be verified.
     * </p>
     * 
     * @return The email address to be verified.
     */
    public String emailAddress() {
        return emailAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyEmailAddressRequest)) {
            return false;
        }
        VerifyEmailAddressRequest other = (VerifyEmailAddressRequest) obj;
        return Objects.equals(emailAddress(), other.emailAddress());
    }

    @Override
    public String toString() {
        return ToString.builder("VerifyEmailAddressRequest").add("EmailAddress", emailAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesRequest.Builder, CopyableBuilder<Builder, VerifyEmailAddressRequest> {
        /**
         * <p>
         * The email address to be verified.
         * </p>
         * 
         * @param emailAddress
         *        The email address to be verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String emailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyEmailAddressRequest model) {
            super(model);
            emailAddress(model.emailAddress);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyEmailAddressRequest build() {
            return new VerifyEmailAddressRequest(this);
        }
    }
}
