/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For more
 * information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReceiptRuleRequest extends SesRequest implements
        ToCopyableBuilder<UpdateReceiptRuleRequest.Builder, UpdateReceiptRuleRequest> {
    private final String ruleSetName;

    private final ReceiptRule rule;

    private UpdateReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The name of the receipt rule set that the receipt rule belongs to.
     * </p>
     * 
     * @return The name of the receipt rule set that the receipt rule belongs to.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * A data structure that contains the updated receipt rule information.
     * </p>
     * 
     * @return A data structure that contains the updated receipt rule information.
     */
    public ReceiptRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReceiptRuleRequest)) {
            return false;
        }
        UpdateReceiptRuleRequest other = (UpdateReceiptRuleRequest) obj;
        return Objects.equals(ruleSetName(), other.ruleSetName()) && Objects.equals(rule(), other.rule());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateReceiptRuleRequest").add("RuleSetName", ruleSetName()).add("Rule", rule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.ofNullable(clazz.cast(ruleSetName()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesRequest.Builder, CopyableBuilder<Builder, UpdateReceiptRuleRequest> {
        /**
         * <p>
         * The name of the receipt rule set that the receipt rule belongs to.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the receipt rule set that the receipt rule belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * A data structure that contains the updated receipt rule information.
         * </p>
         * 
         * @param rule
         *        A data structure that contains the updated receipt rule information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(ReceiptRule rule);

        /**
         * <p>
         * A data structure that contains the updated receipt rule information.
         * </p>
         * This is a convenience that creates an instance of the {@link ReceiptRule.Builder} avoiding the need to create
         * one manually via {@link ReceiptRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptRule.Builder#build()} is called immediately and its result
         * is passed to {@link #rule(ReceiptRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link ReceiptRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(ReceiptRule)
         */
        default Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return rule(ReceiptRule.builder().applyMutation(rule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String ruleSetName;

        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReceiptRuleRequest model) {
            super(model);
            ruleSetName(model.ruleSetName);
            rule(model.rule);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final ReceiptRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReceiptRuleRequest build() {
            return new UpdateReceiptRuleRequest(this);
        }
    }
}
