/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to update the event destination of a configuration set. Configuration sets enable you to publish
 * email sending events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationSetEventDestinationRequest extends SesRequest implements
        ToCopyableBuilder<UpdateConfigurationSetEventDestinationRequest.Builder, UpdateConfigurationSetEventDestinationRequest> {
    private final String configurationSetName;

    private final EventDestination eventDestination;

    private UpdateConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestination = builder.eventDestination;
    }

    /**
     * <p>
     * The name of the configuration set that contains the event destination that you want to update.
     * </p>
     * 
     * @return The name of the configuration set that contains the event destination that you want to update.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The event destination object that you want to apply to the specified configuration set.
     * </p>
     * 
     * @return The event destination object that you want to apply to the specified configuration set.
     */
    public EventDestination eventDestination() {
        return eventDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationSetEventDestinationRequest)) {
            return false;
        }
        UpdateConfigurationSetEventDestinationRequest other = (UpdateConfigurationSetEventDestinationRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestination(), other.eventDestination());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateConfigurationSetEventDestinationRequest")
                .add("ConfigurationSetName", configurationSetName()).add("EventDestination", eventDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestination":
            return Optional.ofNullable(clazz.cast(eventDestination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesRequest.Builder, CopyableBuilder<Builder, UpdateConfigurationSetEventDestinationRequest> {
        /**
         * <p>
         * The name of the configuration set that contains the event destination that you want to update.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that contains the event destination that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The event destination object that you want to apply to the specified configuration set.
         * </p>
         * 
         * @param eventDestination
         *        The event destination object that you want to apply to the specified configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestination(EventDestination eventDestination);

        /**
         * <p>
         * The event destination object that you want to apply to the specified configuration set.
         * </p>
         * This is a convenience that creates an instance of the {@link EventDestination.Builder} avoiding the need to
         * create one manually via {@link EventDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #eventDestination(EventDestination)}.
         * 
         * @param eventDestination
         *        a consumer that will call methods on {@link EventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestination(EventDestination)
         */
        default Builder eventDestination(Consumer<EventDestination.Builder> eventDestination) {
            return eventDestination(EventDestination.builder().applyMutation(eventDestination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private EventDestination eventDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationSetEventDestinationRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            eventDestination(model.eventDestination);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final EventDestination.Builder getEventDestination() {
            return eventDestination != null ? eventDestination.toBuilder() : null;
        }

        @Override
        public final Builder eventDestination(EventDestination eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        public final void setEventDestination(EventDestination.BuilderImpl eventDestination) {
            this.eventDestination = eventDestination != null ? eventDestination.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationSetEventDestinationRequest build() {
            return new UpdateConfigurationSetEventDestinationRequest(this);
        }
    }
}
