/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and
 * click events generated by Amazon SES emails.
 * </p>
 * <p>
 * For more information, see <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
 * Custom Domains to Handle Open and Click Tracking</a> in the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackingOptions implements ToCopyableBuilder<TrackingOptions.Builder, TrackingOptions> {
    private final String customRedirectDomain;

    private TrackingOptions(BuilderImpl builder) {
        this.customRedirectDomain = builder.customRedirectDomain;
    }

    /**
     * <p>
     * The custom subdomain that will be used to redirect email recipients to the Amazon SES event tracking domain.
     * </p>
     * 
     * @return The custom subdomain that will be used to redirect email recipients to the Amazon SES event tracking
     *         domain.
     */
    public String customRedirectDomain() {
        return customRedirectDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customRedirectDomain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingOptions)) {
            return false;
        }
        TrackingOptions other = (TrackingOptions) obj;
        return Objects.equals(customRedirectDomain(), other.customRedirectDomain());
    }

    @Override
    public String toString() {
        return ToString.builder("TrackingOptions").add("CustomRedirectDomain", customRedirectDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomRedirectDomain":
            return Optional.ofNullable(clazz.cast(customRedirectDomain()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TrackingOptions> {
        /**
         * <p>
         * The custom subdomain that will be used to redirect email recipients to the Amazon SES event tracking domain.
         * </p>
         * 
         * @param customRedirectDomain
         *        The custom subdomain that will be used to redirect email recipients to the Amazon SES event tracking
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRedirectDomain(String customRedirectDomain);
    }

    static final class BuilderImpl implements Builder {
        private String customRedirectDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingOptions model) {
            customRedirectDomain(model.customRedirectDomain);
        }

        public final String getCustomRedirectDomain() {
            return customRedirectDomain;
        }

        @Override
        public final Builder customRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
            return this;
        }

        public final void setCustomRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
        }

        @Override
        public TrackingOptions build() {
            return new TrackingOptions(this);
        }
    }
}
