/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to enable or disable whether Amazon SES forwards you bounce and complaint notifications through
 * email. For information about email feedback forwarding, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetIdentityFeedbackForwardingEnabledRequest extends SesRequest implements
        ToCopyableBuilder<SetIdentityFeedbackForwardingEnabledRequest.Builder, SetIdentityFeedbackForwardingEnabledRequest> {
    private final String identity;

    private final Boolean forwardingEnabled;

    private SetIdentityFeedbackForwardingEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.forwardingEnabled = builder.forwardingEnabled;
    }

    /**
     * <p>
     * The identity for which to set bounce and complaint notification forwarding. Examples:
     * <code>user@example.com</code>, <code>example.com</code>.
     * </p>
     * 
     * @return The identity for which to set bounce and complaint notification forwarding. Examples:
     *         <code>user@example.com</code>, <code>example.com</code>.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code> specifies
     * that Amazon SES will forward bounce and complaint notifications as email, in addition to any Amazon SNS topic
     * publishing otherwise specified. <code>false</code> specifies that Amazon SES will publish bounce and complaint
     * notifications only through Amazon SNS. This value can only be set to <code>false</code> when Amazon SNS topics
     * are set for both <code>Bounce</code> and <code>Complaint</code> notification types.
     * </p>
     * 
     * @return Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code>
     *         specifies that Amazon SES will forward bounce and complaint notifications as email, in addition to any
     *         Amazon SNS topic publishing otherwise specified. <code>false</code> specifies that Amazon SES will
     *         publish bounce and complaint notifications only through Amazon SNS. This value can only be set to
     *         <code>false</code> when Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code>
     *         notification types.
     */
    public Boolean forwardingEnabled() {
        return forwardingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityFeedbackForwardingEnabledRequest)) {
            return false;
        }
        SetIdentityFeedbackForwardingEnabledRequest other = (SetIdentityFeedbackForwardingEnabledRequest) obj;
        return Objects.equals(identity(), other.identity()) && Objects.equals(forwardingEnabled(), other.forwardingEnabled());
    }

    @Override
    public String toString() {
        return ToString.builder("SetIdentityFeedbackForwardingEnabledRequest").add("Identity", identity())
                .add("ForwardingEnabled", forwardingEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "ForwardingEnabled":
            return Optional.ofNullable(clazz.cast(forwardingEnabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesRequest.Builder, CopyableBuilder<Builder, SetIdentityFeedbackForwardingEnabledRequest> {
        /**
         * <p>
         * The identity for which to set bounce and complaint notification forwarding. Examples:
         * <code>user@example.com</code>, <code>example.com</code>.
         * </p>
         * 
         * @param identity
         *        The identity for which to set bounce and complaint notification forwarding. Examples:
         *        <code>user@example.com</code>, <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code> specifies
         * that Amazon SES will forward bounce and complaint notifications as email, in addition to any Amazon SNS topic
         * publishing otherwise specified. <code>false</code> specifies that Amazon SES will publish bounce and
         * complaint notifications only through Amazon SNS. This value can only be set to <code>false</code> when Amazon
         * SNS topics are set for both <code>Bounce</code> and <code>Complaint</code> notification types.
         * </p>
         * 
         * @param forwardingEnabled
         *        Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code>
         *        specifies that Amazon SES will forward bounce and complaint notifications as email, in addition to any
         *        Amazon SNS topic publishing otherwise specified. <code>false</code> specifies that Amazon SES will
         *        publish bounce and complaint notifications only through Amazon SNS. This value can only be set to
         *        <code>false</code> when Amazon SNS topics are set for both <code>Bounce</code> and
         *        <code>Complaint</code> notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingEnabled(Boolean forwardingEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String identity;

        private Boolean forwardingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityFeedbackForwardingEnabledRequest model) {
            super(model);
            identity(model.identity);
            forwardingEnabled(model.forwardingEnabled);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Boolean getForwardingEnabled() {
            return forwardingEnabled;
        }

        @Override
        public final Builder forwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
            return this;
        }

        public final void setForwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityFeedbackForwardingEnabledRequest build() {
            return new SetIdentityFeedbackForwardingEnabledRequest(this);
        }
    }
}
