/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or
 * range of IP addresses.
 * </p>
 * <p>
 * For information about setting up IP address filters, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReceiptFilter implements ToCopyableBuilder<ReceiptFilter.Builder, ReceiptFilter> {
    private final String name;

    private final ReceiptIpFilter ipFilter;

    private ReceiptFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.ipFilter = builder.ipFilter;
    }

    /**
     * <p>
     * The name of the IP address filter. The name must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start and end with a letter or number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Contain less than 64 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the IP address filter. The name must:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start and end with a letter or number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Contain less than 64 characters.
     *         </p>
     *         </li>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail from
     * them.
     * </p>
     * 
     * @return A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
     *         from them.
     */
    public ReceiptIpFilter ipFilter() {
        return ipFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipFilter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptFilter)) {
            return false;
        }
        ReceiptFilter other = (ReceiptFilter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ipFilter(), other.ipFilter());
    }

    @Override
    public String toString() {
        return ToString.builder("ReceiptFilter").add("Name", name()).add("IpFilter", ipFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IpFilter":
            return Optional.ofNullable(clazz.cast(ipFilter()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReceiptFilter> {
        /**
         * <p>
         * The name of the IP address filter. The name must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start and end with a letter or number.
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain less than 64 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the IP address filter. The name must:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start and end with a letter or number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain less than 64 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
         * from them.
         * </p>
         * 
         * @param ipFilter
         *        A structure that provides the IP addresses to block or allow, and whether to block or allow incoming
         *        mail from them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipFilter(ReceiptIpFilter ipFilter);

        /**
         * <p>
         * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
         * from them.
         * </p>
         * This is a convenience that creates an instance of the {@link ReceiptIpFilter.Builder} avoiding the need to
         * create one manually via {@link ReceiptIpFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptIpFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #ipFilter(ReceiptIpFilter)}.
         * 
         * @param ipFilter
         *        a consumer that will call methods on {@link ReceiptIpFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipFilter(ReceiptIpFilter)
         */
        default Builder ipFilter(Consumer<ReceiptIpFilter.Builder> ipFilter) {
            return ipFilter(ReceiptIpFilter.builder().applyMutation(ipFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ReceiptIpFilter ipFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptFilter model) {
            name(model.name);
            ipFilter(model.ipFilter);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ReceiptIpFilter.Builder getIpFilter() {
            return ipFilter != null ? ipFilter.toBuilder() : null;
        }

        @Override
        public final Builder ipFilter(ReceiptIpFilter ipFilter) {
            this.ipFilter = ipFilter;
            return this;
        }

        public final void setIpFilter(ReceiptIpFilter.BuilderImpl ipFilter) {
            this.ipFilter = ipFilter != null ? ipFilter.build() : null;
        }

        @Override
        public ReceiptFilter build() {
            return new ReceiptFilter(this);
        }
    }
}
