/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional X-headers to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on
 * your behalf bounces.
 * </p>
 * <p>
 * For information about receiving email through Amazon SES, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtensionField implements ToCopyableBuilder<ExtensionField.Builder, ExtensionField> {
    private final String name;

    private final String value;

    private ExtensionField(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z,
     * A-Z, 0-9) characters and dashes only.
     * </p>
     * 
     * @return The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
     *         alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the header to add. Must be less than 2048 characters, and must not contain newline characters ("\r"
     * or "\n").
     * </p>
     * 
     * @return The value of the header to add. Must be less than 2048 characters, and must not contain newline
     *         characters ("\r" or "\n").
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionField)) {
            return false;
        }
        ExtensionField other = (ExtensionField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("ExtensionField").add("Name", name()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ExtensionField> {
        /**
         * <p>
         * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric
         * (a-z, A-Z, 0-9) characters and dashes only.
         * </p>
         * 
         * @param name
         *        The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
         *        alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the header to add. Must be less than 2048 characters, and must not contain newline characters
         * ("\r" or "\n").
         * </p>
         * 
         * @param value
         *        The value of the header to add. Must be less than 2048 characters, and must not contain newline
         *        characters ("\r" or "\n").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtensionField model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ExtensionField build() {
            return new ExtensionField(this);
        }
    }
}
