/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
 * </p>
 * <p>
 * By default, the string must be 7-bit ASCII. If the text must contain any other characters, then you must use MIME
 * encoded-word syntax (RFC 2047) instead of a literal string. MIME encoded-word syntax uses the following form:
 * <code>=?charset?encoding?encoded-text?=</code>. For more information, see <a
 * href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements ToCopyableBuilder<Destination.Builder, Destination> {
    private final List<String> toAddresses;

    private final List<String> ccAddresses;

    private final List<String> bccAddresses;

    private Destination(BuilderImpl builder) {
        this.toAddresses = builder.toAddresses;
        this.ccAddresses = builder.ccAddresses;
        this.bccAddresses = builder.bccAddresses;
    }

    /**
     * <p>
     * The To: field(s) of the message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The To: field(s) of the message.
     */
    public List<String> toAddresses() {
        return toAddresses;
    }

    /**
     * <p>
     * The CC: field(s) of the message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The CC: field(s) of the message.
     */
    public List<String> ccAddresses() {
        return ccAddresses;
    }

    /**
     * <p>
     * The BCC: field(s) of the message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The BCC: field(s) of the message.
     */
    public List<String> bccAddresses() {
        return bccAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(ccAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(bccAddresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(toAddresses(), other.toAddresses()) && Objects.equals(ccAddresses(), other.ccAddresses())
                && Objects.equals(bccAddresses(), other.bccAddresses());
    }

    @Override
    public String toString() {
        return ToString.builder("Destination").add("ToAddresses", toAddresses()).add("CcAddresses", ccAddresses())
                .add("BccAddresses", bccAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ToAddresses":
            return Optional.ofNullable(clazz.cast(toAddresses()));
        case "CcAddresses":
            return Optional.ofNullable(clazz.cast(ccAddresses()));
        case "BccAddresses":
            return Optional.ofNullable(clazz.cast(bccAddresses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * The To: field(s) of the message.
         * </p>
         * 
         * @param toAddresses
         *        The To: field(s) of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toAddresses(Collection<String> toAddresses);

        /**
         * <p>
         * The To: field(s) of the message.
         * </p>
         * 
         * @param toAddresses
         *        The To: field(s) of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toAddresses(String... toAddresses);

        /**
         * <p>
         * The CC: field(s) of the message.
         * </p>
         * 
         * @param ccAddresses
         *        The CC: field(s) of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccAddresses(Collection<String> ccAddresses);

        /**
         * <p>
         * The CC: field(s) of the message.
         * </p>
         * 
         * @param ccAddresses
         *        The CC: field(s) of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccAddresses(String... ccAddresses);

        /**
         * <p>
         * The BCC: field(s) of the message.
         * </p>
         * 
         * @param bccAddresses
         *        The BCC: field(s) of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bccAddresses(Collection<String> bccAddresses);

        /**
         * <p>
         * The BCC: field(s) of the message.
         * </p>
         * 
         * @param bccAddresses
         *        The BCC: field(s) of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bccAddresses(String... bccAddresses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> toAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> ccAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> bccAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            toAddresses(model.toAddresses);
            ccAddresses(model.ccAddresses);
            bccAddresses(model.bccAddresses);
        }

        public final Collection<String> getToAddresses() {
            return toAddresses;
        }

        @Override
        public final Builder toAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(String... toAddresses) {
            toAddresses(Arrays.asList(toAddresses));
            return this;
        }

        public final void setToAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
        }

        public final Collection<String> getCcAddresses() {
            return ccAddresses;
        }

        @Override
        public final Builder ccAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(String... ccAddresses) {
            ccAddresses(Arrays.asList(ccAddresses));
            return this;
        }

        public final void setCcAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
        }

        public final Collection<String> getBccAddresses() {
            return bccAddresses;
        }

        @Override
        public final Builder bccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bccAddresses(String... bccAddresses) {
            bccAddresses(Arrays.asList(bccAddresses));
            return this;
        }

        public final void setBccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }
    }
}
