/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents textual data, plus an optional character set specification.
 * </p>
 * <p>
 * By default, the text must be 7-bit ASCII, due to the constraints of the SMTP protocol. If the text must contain any
 * other characters, then you must also specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Content implements ToCopyableBuilder<Content.Builder, Content> {
    private final String data;

    private final String charset;

    private Content(BuilderImpl builder) {
        this.data = builder.data;
        this.charset = builder.charset;
    }

    /**
     * <p>
     * The textual data of the content.
     * </p>
     * 
     * @return The textual data of the content.
     */
    public String data() {
        return data;
    }

    /**
     * <p>
     * The character set of the content.
     * </p>
     * 
     * @return The character set of the content.
     */
    public String charset() {
        return charset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(charset());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Content)) {
            return false;
        }
        Content other = (Content) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(charset(), other.charset());
    }

    @Override
    public String toString() {
        return ToString.builder("Content").add("Data", data()).add("Charset", charset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "Charset":
            return Optional.ofNullable(clazz.cast(charset()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Content> {
        /**
         * <p>
         * The textual data of the content.
         * </p>
         * 
         * @param data
         *        The textual data of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * The character set of the content.
         * </p>
         * 
         * @param charset
         *        The character set of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder charset(String charset);
    }

    static final class BuilderImpl implements Builder {
        private String data;

        private String charset;

        private BuilderImpl() {
        }

        private BuilderImpl(Content model) {
            data(model.data);
            charset(model.charset);
        }

        public final String getData() {
            return data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getCharset() {
            return charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        @Override
        public Content build() {
            return new Content(this);
        }
    }
}
