/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetIdentityMailFromDomainRequestMarshaller
implements Marshaller<Request<SetIdentityMailFromDomainRequest>, SetIdentityMailFromDomainRequest> {
    public Request<SetIdentityMailFromDomainRequest> marshall(SetIdentityMailFromDomainRequest setIdentityMailFromDomainRequest) {
        if (setIdentityMailFromDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setIdentityMailFromDomainRequest, "SESClient");
        request.addParameter("Action", "SetIdentityMailFromDomain");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIdentityMailFromDomainRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)setIdentityMailFromDomainRequest.identity()));
        }
        if (setIdentityMailFromDomainRequest.mailFromDomain() != null) {
            request.addParameter("MailFromDomain", StringUtils.fromString((String)setIdentityMailFromDomainRequest.mailFromDomain()));
        }
        if (setIdentityMailFromDomainRequest.behaviorOnMXFailure() != null) {
            request.addParameter("BehaviorOnMXFailure", StringUtils.fromString((String)setIdentityMailFromDomainRequest.behaviorOnMXFailure()));
        }
        return request;
    }
}

