/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteIdentityPolicyRequestMarshaller
implements Marshaller<Request<DeleteIdentityPolicyRequest>, DeleteIdentityPolicyRequest> {
    public Request<DeleteIdentityPolicyRequest> marshall(DeleteIdentityPolicyRequest deleteIdentityPolicyRequest) {
        if (deleteIdentityPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteIdentityPolicyRequest, "SESClient");
        request.addParameter("Action", "DeleteIdentityPolicy");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIdentityPolicyRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)deleteIdentityPolicyRequest.identity()));
        }
        if (deleteIdentityPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)deleteIdentityPolicyRequest.policyName()));
        }
        return request;
    }
}

