/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendRawEmailRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendRawEmailRequest> {
    private final String source;
    private final List<String> destinations;
    private final RawMessage rawMessage;
    private final String fromArn;
    private final String sourceArn;
    private final String returnPathArn;
    private final List<MessageTag> tags;
    private final String configurationSetName;

    private SendRawEmailRequest(BuilderImpl builder) {
        this.source = builder.source;
        this.destinations = builder.destinations;
        this.rawMessage = builder.rawMessage;
        this.fromArn = builder.fromArn;
        this.sourceArn = builder.sourceArn;
        this.returnPathArn = builder.returnPathArn;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
    }

    public String source() {
        return this.source;
    }

    public List<String> destinations() {
        return this.destinations;
    }

    public RawMessage rawMessage() {
        return this.rawMessage;
    }

    public String fromArn() {
        return this.fromArn;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String returnPathArn() {
        return this.returnPathArn;
    }

    public List<MessageTag> tags() {
        return this.tags;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.destinations() == null ? 0 : this.destinations().hashCode());
        hashCode = 31 * hashCode + (this.rawMessage() == null ? 0 : this.rawMessage().hashCode());
        hashCode = 31 * hashCode + (this.fromArn() == null ? 0 : this.fromArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceArn() == null ? 0 : this.sourceArn().hashCode());
        hashCode = 31 * hashCode + (this.returnPathArn() == null ? 0 : this.returnPathArn().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.configurationSetName() == null ? 0 : this.configurationSetName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendRawEmailRequest)) {
            return false;
        }
        SendRawEmailRequest other = (SendRawEmailRequest)((Object)obj);
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.destinations() == null ^ this.destinations() == null) {
            return false;
        }
        if (other.destinations() != null && !other.destinations().equals(this.destinations())) {
            return false;
        }
        if (other.rawMessage() == null ^ this.rawMessage() == null) {
            return false;
        }
        if (other.rawMessage() != null && !other.rawMessage().equals(this.rawMessage())) {
            return false;
        }
        if (other.fromArn() == null ^ this.fromArn() == null) {
            return false;
        }
        if (other.fromArn() != null && !other.fromArn().equals(this.fromArn())) {
            return false;
        }
        if (other.sourceArn() == null ^ this.sourceArn() == null) {
            return false;
        }
        if (other.sourceArn() != null && !other.sourceArn().equals(this.sourceArn())) {
            return false;
        }
        if (other.returnPathArn() == null ^ this.returnPathArn() == null) {
            return false;
        }
        if (other.returnPathArn() != null && !other.returnPathArn().equals(this.returnPathArn())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        return other.configurationSetName() == null || other.configurationSetName().equals(this.configurationSetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.destinations() != null) {
            sb.append("Destinations: ").append(this.destinations()).append(",");
        }
        if (this.rawMessage() != null) {
            sb.append("RawMessage: ").append(this.rawMessage()).append(",");
        }
        if (this.fromArn() != null) {
            sb.append("FromArn: ").append(this.fromArn()).append(",");
        }
        if (this.sourceArn() != null) {
            sb.append("SourceArn: ").append(this.sourceArn()).append(",");
        }
        if (this.returnPathArn() != null) {
            sb.append("ReturnPathArn: ").append(this.returnPathArn()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.configurationSetName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String source;
        private List<String> destinations = new SdkInternalList();
        private RawMessage rawMessage;
        private String fromArn;
        private String sourceArn;
        private String returnPathArn;
        private List<MessageTag> tags = new SdkInternalList();
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendRawEmailRequest model) {
            this.setSource(model.source);
            this.setDestinations(model.destinations);
            this.setRawMessage(model.rawMessage);
            this.setFromArn(model.fromArn);
            this.setSourceArn(model.sourceArn);
            this.setReturnPathArn(model.returnPathArn);
            this.setTags(model.tags);
            this.setConfigurationSetName(model.configurationSetName);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Collection<String> getDestinations() {
            return this.destinations;
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            if (this.destinations == null) {
                this.destinations = new SdkInternalList(destinations.length);
            }
            for (String e : destinations) {
                this.destinations.add(e);
            }
            return this;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
        }

        @SafeVarargs
        public final void setDestinations(String ... destinations) {
            if (this.destinations == null) {
                this.destinations = new SdkInternalList(destinations.length);
            }
            for (String e : destinations) {
                this.destinations.add(e);
            }
        }

        public final RawMessage getRawMessage() {
            return this.rawMessage;
        }

        @Override
        public final Builder rawMessage(RawMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public final void setRawMessage(RawMessage rawMessage) {
            this.rawMessage = rawMessage;
        }

        public final String getFromArn() {
            return this.fromArn;
        }

        @Override
        public final Builder fromArn(String fromArn) {
            this.fromArn = fromArn;
            return this;
        }

        public final void setFromArn(String fromArn) {
            this.fromArn = fromArn;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        public final Collection<MessageTag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(MessageTag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (MessageTag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(MessageTag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (MessageTag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public SendRawEmailRequest build() {
            return new SendRawEmailRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendRawEmailRequest> {
        public Builder source(String var1);

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder rawMessage(RawMessage var1);

        public Builder fromArn(String var1);

        public Builder sourceArn(String var1);

        public Builder returnPathArn(String var1);

        public Builder tags(Collection<MessageTag> var1);

        public Builder tags(MessageTag ... var1);

        public Builder configurationSetName(String var1);
    }
}

