/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReceiptRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReceiptRuleRequest> {
    private final String ruleSetName;
    private final String ruleName;

    private DescribeReceiptRuleRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.ruleName = builder.ruleName;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleSetName() == null ? 0 : this.ruleSetName().hashCode());
        hashCode = 31 * hashCode + (this.ruleName() == null ? 0 : this.ruleName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleRequest)) {
            return false;
        }
        DescribeReceiptRuleRequest other = (DescribeReceiptRuleRequest)((Object)obj);
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.ruleName() == null ^ this.ruleName() == null) {
            return false;
        }
        return other.ruleName() == null || other.ruleName().equals(this.ruleName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ruleSetName() != null) {
            sb.append("RuleSetName: ").append(this.ruleSetName()).append(",");
        }
        if (this.ruleName() != null) {
            sb.append("RuleName: ").append(this.ruleName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleRequest model) {
            this.setRuleSetName(model.ruleSetName);
            this.setRuleName(model.ruleName);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public DescribeReceiptRuleRequest build() {
            return new DescribeReceiptRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReceiptRuleRequest> {
        public Builder ruleSetName(String var1);

        public Builder ruleName(String var1);
    }
}

