/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Content
implements ToCopyableBuilder<Builder, Content> {
    private final String data;
    private final String charset;

    private Content(BuilderImpl builder) {
        this.data = builder.data;
        this.charset = builder.charset;
    }

    public String data() {
        return this.data;
    }

    public String charset() {
        return this.charset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.charset() == null ? 0 : this.charset().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Content)) {
            return false;
        }
        Content other = (Content)obj;
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.charset() == null ^ this.charset() == null) {
            return false;
        }
        return other.charset() == null || other.charset().equals(this.charset());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.charset() != null) {
            sb.append("Charset: ").append(this.charset()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String data;
        private String charset;

        private BuilderImpl() {
        }

        private BuilderImpl(Content model) {
            this.setData(model.data);
            this.setCharset(model.charset);
        }

        public final String getData() {
            return this.data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getCharset() {
            return this.charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        public Content build() {
            return new Content(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Content> {
        public Builder data(String var1);

        public Builder charset(String var1);
    }
}

