/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BounceAction
implements ToCopyableBuilder<Builder, BounceAction> {
    private final String topicArn;
    private final String smtpReplyCode;
    private final String statusCode;
    private final String message;
    private final String sender;

    private BounceAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.smtpReplyCode = builder.smtpReplyCode;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.sender = builder.sender;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String smtpReplyCode() {
        return this.smtpReplyCode;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String message() {
        return this.message;
    }

    public String sender() {
        return this.sender;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.smtpReplyCode() == null ? 0 : this.smtpReplyCode().hashCode());
        hashCode = 31 * hashCode + (this.statusCode() == null ? 0 : this.statusCode().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.sender() == null ? 0 : this.sender().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BounceAction)) {
            return false;
        }
        BounceAction other = (BounceAction)obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.smtpReplyCode() == null ^ this.smtpReplyCode() == null) {
            return false;
        }
        if (other.smtpReplyCode() != null && !other.smtpReplyCode().equals(this.smtpReplyCode())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.sender() == null ^ this.sender() == null) {
            return false;
        }
        return other.sender() == null || other.sender().equals(this.sender());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.smtpReplyCode() != null) {
            sb.append("SmtpReplyCode: ").append(this.smtpReplyCode()).append(",");
        }
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.sender() != null) {
            sb.append("Sender: ").append(this.sender()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String smtpReplyCode;
        private String statusCode;
        private String message;
        private String sender;

        private BuilderImpl() {
        }

        private BuilderImpl(BounceAction model) {
            this.setTopicArn(model.topicArn);
            this.setSmtpReplyCode(model.smtpReplyCode);
            this.setStatusCode(model.statusCode);
            this.setMessage(model.message);
            this.setSender(model.sender);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getSmtpReplyCode() {
            return this.smtpReplyCode;
        }

        @Override
        public final Builder smtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
            return this;
        }

        public final void setSmtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSender() {
            return this.sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        public BounceAction build() {
            return new BounceAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BounceAction> {
        public Builder topicArn(String var1);

        public Builder smtpReplyCode(String var1);

        public Builder statusCode(String var1);

        public Builder message(String var1);

        public Builder sender(String var1);
    }
}

